// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The ResponsesFileSearchCallItemResult model.
 */
@Fluent
public final class ResponsesFileSearchCallItemResult implements JsonSerializable<ResponsesFileSearchCallItemResult> {

    /*
     * The file_id property.
     */
    @Generated
    private String fileId;

    /*
     * The text property.
     */
    @Generated
    private String text;

    /*
     * The filename property.
     */
    @Generated
    private String filename;

    /*
     * The attributes property.
     */
    @Generated
    private Map<String, BinaryData> attributes;

    /*
     * The score property.
     */
    @Generated
    private Double score;

    /**
     * Creates an instance of ResponsesFileSearchCallItemResult class.
     */
    @Generated
    public ResponsesFileSearchCallItemResult() {
    }

    /**
     * Get the fileId property: The file_id property.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Set the fileId property: The file_id property.
     *
     * @param fileId the fileId value to set.
     * @return the ResponsesFileSearchCallItemResult object itself.
     */
    @Generated
    public ResponsesFileSearchCallItemResult setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * Get the text property: The text property.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The text property.
     *
     * @param text the text value to set.
     * @return the ResponsesFileSearchCallItemResult object itself.
     */
    @Generated
    public ResponsesFileSearchCallItemResult setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the filename property: The filename property.
     *
     * @return the filename value.
     */
    @Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * Set the filename property: The filename property.
     *
     * @param filename the filename value to set.
     * @return the ResponsesFileSearchCallItemResult object itself.
     */
    @Generated
    public ResponsesFileSearchCallItemResult setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    /**
     * Get the attributes property: The attributes property.
     *
     * @return the attributes value.
     */
    @Generated
    public Map<String, BinaryData> getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The attributes property.
     *
     * @param attributes the attributes value to set.
     * @return the ResponsesFileSearchCallItemResult object itself.
     */
    @Generated
    public ResponsesFileSearchCallItemResult setAttributes(Map<String, BinaryData> attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * Get the score property: The score property.
     *
     * @return the score value.
     */
    @Generated
    public Double getScore() {
        return this.score;
    }

    /**
     * Set the score property: The score property.
     *
     * @param score the score value to set.
     * @return the ResponsesFileSearchCallItemResult object itself.
     */
    @Generated
    public ResponsesFileSearchCallItemResult setScore(Double score) {
        this.score = score;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeMapField("attributes", this.attributes,
            (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeNumberField("score", this.score);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesFileSearchCallItemResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesFileSearchCallItemResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesFileSearchCallItemResult.
     */
    @Generated
    public static ResponsesFileSearchCallItemResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesFileSearchCallItemResult deserializedResponsesFileSearchCallItemResult
                = new ResponsesFileSearchCallItemResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    deserializedResponsesFileSearchCallItemResult.fileId = reader.getString();
                } else if ("text".equals(fieldName)) {
                    deserializedResponsesFileSearchCallItemResult.text = reader.getString();
                } else if ("filename".equals(fieldName)) {
                    deserializedResponsesFileSearchCallItemResult.filename = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    Map<String, BinaryData> attributes = reader.readMap(reader1 -> reader1
                        .getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped())));
                    deserializedResponsesFileSearchCallItemResult.attributes = attributes;
                } else if ("score".equals(fieldName)) {
                    deserializedResponsesFileSearchCallItemResult.score = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesFileSearchCallItemResult;
        });
    }
}
