// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ResponsesFileSearchTool model.
 */
@Fluent
public final class ResponsesFileSearchTool extends ResponsesTool {

    /*
     * The type property.
     */
    @Generated
    private ResponsesToolType type = ResponsesToolType.FILE_SEARCH;

    /*
     * The vector_store_ids property.
     */
    @Generated
    private final List<String> vectorStoreIds;

    /*
     * The max_num_results property.
     */
    @Generated
    private Integer maxNumResults;

    /*
     * The ranking_options property.
     */
    @Generated
    private ResponsesFileSearchToolRankingOptions rankingOptions;

    /*
     * The filters property.
     */
    @Generated
    private BinaryData filters;

    /**
     * Creates an instance of ResponsesFileSearchTool class.
     *
     * @param vectorStoreIds the vectorStoreIds value to set.
     */
    @Generated
    public ResponsesFileSearchTool(List<String> vectorStoreIds) {
        this.vectorStoreIds = vectorStoreIds;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    /**
     * Get the vectorStoreIds property: The vector_store_ids property.
     *
     * @return the vectorStoreIds value.
     */
    @Generated
    public List<String> getVectorStoreIds() {
        return this.vectorStoreIds;
    }

    /**
     * Get the maxNumResults property: The max_num_results property.
     *
     * @return the maxNumResults value.
     */
    @Generated
    public Integer getMaxNumResults() {
        return this.maxNumResults;
    }

    /**
     * Set the maxNumResults property: The max_num_results property.
     *
     * @param maxNumResults the maxNumResults value to set.
     * @return the ResponsesFileSearchTool object itself.
     */
    @Generated
    public ResponsesFileSearchTool setMaxNumResults(Integer maxNumResults) {
        this.maxNumResults = maxNumResults;
        return this;
    }

    /**
     * Get the rankingOptions property: The ranking_options property.
     *
     * @return the rankingOptions value.
     */
    @Generated
    public ResponsesFileSearchToolRankingOptions getRankingOptions() {
        return this.rankingOptions;
    }

    /**
     * Set the rankingOptions property: The ranking_options property.
     *
     * @param rankingOptions the rankingOptions value to set.
     * @return the ResponsesFileSearchTool object itself.
     */
    @Generated
    public ResponsesFileSearchTool setRankingOptions(ResponsesFileSearchToolRankingOptions rankingOptions) {
        this.rankingOptions = rankingOptions;
        return this;
    }

    /**
     * Get the filters property: The filters property.
     *
     * @return the filters value.
     */
    @Generated
    public BinaryData getFilters() {
        return this.filters;
    }

    /**
     * Set the filters property: The filters property.
     *
     * @param filters the filters value to set.
     * @return the ResponsesFileSearchTool object itself.
     */
    @Generated
    public ResponsesFileSearchTool setFilters(BinaryData filters) {
        this.filters = filters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vector_store_ids", this.vectorStoreIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("max_num_results", this.maxNumResults);
        jsonWriter.writeJsonField("ranking_options", this.rankingOptions);
        if (this.filters != null) {
            jsonWriter.writeFieldName("filters");
            this.filters.writeTo(jsonWriter);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesFileSearchTool from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesFileSearchTool if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesFileSearchTool.
     */
    @Generated
    public static ResponsesFileSearchTool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<String> vectorStoreIds = null;
            ResponsesToolType type = ResponsesToolType.FILE_SEARCH;
            Integer maxNumResults = null;
            ResponsesFileSearchToolRankingOptions rankingOptions = null;
            BinaryData filters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vector_store_ids".equals(fieldName)) {
                    vectorStoreIds = reader.readArray(reader1 -> reader1.getString());
                } else if ("type".equals(fieldName)) {
                    type = ResponsesToolType.fromString(reader.getString());
                } else if ("max_num_results".equals(fieldName)) {
                    maxNumResults = reader.getNullable(JsonReader::getInt);
                } else if ("ranking_options".equals(fieldName)) {
                    rankingOptions = ResponsesFileSearchToolRankingOptions.fromJson(reader);
                } else if ("filters".equals(fieldName)) {
                    filters = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesFileSearchTool deserializedResponsesFileSearchTool = new ResponsesFileSearchTool(vectorStoreIds);
            deserializedResponsesFileSearchTool.type = type;
            deserializedResponsesFileSearchTool.maxNumResults = maxNumResults;
            deserializedResponsesFileSearchTool.rankingOptions = rankingOptions;
            deserializedResponsesFileSearchTool.filters = filters;
            return deserializedResponsesFileSearchTool;
        });
    }
}
