// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesInputContentFile model.
 */
@Fluent
public final class ResponsesInputContentFile extends ResponsesContent {

    /*
     * The type property.
     */
    @Generated
    private ResponsesContentType type = ResponsesContentType.INPUT_FILE;

    /*
     * The file_id property.
     */
    @Generated
    private String fileId;

    /*
     * The filename property.
     */
    @Generated
    private String filename;

    /*
     * The file_data property.
     */
    @Generated
    private String fileData;

    /**
     * Creates an instance of ResponsesInputContentFile class.
     */
    @Generated
    public ResponsesInputContentFile() {
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    /**
     * Get the fileId property: The file_id property.
     *
     * @return the fileId value.
     */
    @Generated
    public String getFileId() {
        return this.fileId;
    }

    /**
     * Set the fileId property: The file_id property.
     *
     * @param fileId the fileId value to set.
     * @return the ResponsesInputContentFile object itself.
     */
    @Generated
    public ResponsesInputContentFile setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * Get the filename property: The filename property.
     *
     * @return the filename value.
     */
    @Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * Set the filename property: The filename property.
     *
     * @param filename the filename value to set.
     * @return the ResponsesInputContentFile object itself.
     */
    @Generated
    public ResponsesInputContentFile setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    /**
     * Get the fileData property: The file_data property.
     *
     * @return the fileData value.
     */
    @Generated
    public String getFileData() {
        return this.fileData;
    }

    /**
     * Set the fileData property: The file_data property.
     *
     * @param fileData the fileData value to set.
     * @return the ResponsesInputContentFile object itself.
     */
    @Generated
    public ResponsesInputContentFile setFileData(String fileData) {
        this.fileData = fileData;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeStringField("file_data", this.fileData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesInputContentFile from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesInputContentFile if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesInputContentFile.
     */
    @Generated
    public static ResponsesInputContentFile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesInputContentFile deserializedResponsesInputContentFile = new ResponsesInputContentFile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesInputContentFile.type = ResponsesContentType.fromString(reader.getString());
                } else if ("file_id".equals(fieldName)) {
                    deserializedResponsesInputContentFile.fileId = reader.getString();
                } else if ("filename".equals(fieldName)) {
                    deserializedResponsesInputContentFile.filename = reader.getString();
                } else if ("file_data".equals(fieldName)) {
                    deserializedResponsesInputContentFile.fileData = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesInputContentFile;
        });
    }
}
