// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesInputContentText model.
 */
@Immutable
public final class ResponsesInputContentText extends ResponsesContent {

    /*
     * The type property.
     */
    @Generated
    private ResponsesContentType type = ResponsesContentType.INPUT_TEXT;

    /*
     * The text property.
     */
    @Generated
    private final String text;

    /**
     * Creates an instance of ResponsesInputContentText class.
     *
     * @param text the text value to set.
     */
    @Generated
    public ResponsesInputContentText(String text) {
        this.text = text;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    /**
     * Get the text property: The text property.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesInputContentText from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesInputContentText if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesInputContentText.
     */
    @Generated
    public static ResponsesInputContentText fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String text = null;
            ResponsesContentType type = ResponsesContentType.INPUT_TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponsesContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesInputContentText deserializedResponsesInputContentText = new ResponsesInputContentText(text);
            deserializedResponsesInputContentText.type = type;
            return deserializedResponsesInputContentText;
        });
    }
}
