// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * **o-series models only**
 *
 * Configuration options for reasoning models.
 */
@Fluent
public final class ResponsesReasoningConfiguration implements JsonSerializable<ResponsesReasoningConfiguration> {

    /*
     * The effort property.
     */
    @Generated
    private final ResponsesReasoningConfigurationEffort effort;

    /*
     * The generate_summary property.
     */
    @Generated
    private ResponsesReasoningConfigurationGenerateSummary generateSummary;

    /**
     * Creates an instance of ResponsesReasoningConfiguration class.
     *
     * @param effort the effort value to set.
     */
    @Generated
    public ResponsesReasoningConfiguration(ResponsesReasoningConfigurationEffort effort) {
        this.effort = effort;
    }

    /**
     * Get the effort property: The effort property.
     *
     * @return the effort value.
     */
    @Generated
    public ResponsesReasoningConfigurationEffort getEffort() {
        return this.effort;
    }

    /**
     * Get the generateSummary property: The generate_summary property.
     *
     * @return the generateSummary value.
     */
    @Generated
    public ResponsesReasoningConfigurationGenerateSummary getGenerateSummary() {
        return this.generateSummary;
    }

    /**
     * Set the generateSummary property: The generate_summary property.
     *
     * @param generateSummary the generateSummary value to set.
     * @return the ResponsesReasoningConfiguration object itself.
     */
    @Generated
    public ResponsesReasoningConfiguration
        setGenerateSummary(ResponsesReasoningConfigurationGenerateSummary generateSummary) {
        this.generateSummary = generateSummary;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("effort", this.effort == null ? null : this.effort.toString());
        jsonWriter.writeStringField("generate_summary",
            this.generateSummary == null ? null : this.generateSummary.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesReasoningConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesReasoningConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesReasoningConfiguration.
     */
    @Generated
    public static ResponsesReasoningConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesReasoningConfigurationEffort effort = null;
            ResponsesReasoningConfigurationGenerateSummary generateSummary = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("effort".equals(fieldName)) {
                    effort = ResponsesReasoningConfigurationEffort.fromString(reader.getString());
                } else if ("generate_summary".equals(fieldName)) {
                    generateSummary = ResponsesReasoningConfigurationGenerateSummary.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesReasoningConfiguration deserializedResponsesReasoningConfiguration
                = new ResponsesReasoningConfiguration(effort);
            deserializedResponsesReasoningConfiguration.generateSummary = generateSummary;
            return deserializedResponsesReasoningConfiguration;
        });
    }
}
