// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesReasoningConfigurationEffort.
 */
public enum ResponsesReasoningConfigurationEffort {
    /**
     * Enum value low.
     */
    LOW("low"),

    /**
     * Enum value medium.
     */
    MEDIUM("medium"),

    /**
     * Enum value high.
     */
    HIGH("high");

    /**
     * The actual serialized value for a ResponsesReasoningConfigurationEffort instance.
     */
    private final String value;

    ResponsesReasoningConfigurationEffort(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesReasoningConfigurationEffort instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesReasoningConfigurationEffort object, or null if unable to parse.
     */
    public static ResponsesReasoningConfigurationEffort fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesReasoningConfigurationEffort[] items = ResponsesReasoningConfigurationEffort.values();
        for (ResponsesReasoningConfigurationEffort item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
