// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Returned when the model-generated function call arguments are done streaming.
 * Also emitted when a Response is interrupted, incomplete, or cancelled.
 */
@Immutable
public final class ResponsesStreamEventFunctionCallArgumentsDone extends ResponsesStreamEvent {

    /*
     * The type property.
     */
    @Generated
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE;

    /*
     * The ID of the item that this stream event applies to.
     */
    @Generated
    private final String itemId;

    /*
     * The index of the output item within the response that this stream event applies to.
     */
    @Generated
    private final int outputIndex;

    /*
     * The final function call arguments as a complete JSON string.
     */
    @Generated
    private final String arguments;

    /**
     * Creates an instance of ResponsesStreamEventFunctionCallArgumentsDone class.
     *
     * @param itemId the itemId value to set.
     * @param outputIndex the outputIndex value to set.
     * @param arguments the arguments value to set.
     */
    @Generated
    private ResponsesStreamEventFunctionCallArgumentsDone(String itemId, int outputIndex, String arguments) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.arguments = arguments;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    /**
     * Get the itemId property: The ID of the item that this stream event applies to.
     *
     * @return the itemId value.
     */
    @Generated
    public String getItemId() {
        return this.itemId;
    }

    /**
     * Get the outputIndex property: The index of the output item within the response that this stream event applies to.
     *
     * @return the outputIndex value.
     */
    @Generated
    public int getOutputIndex() {
        return this.outputIndex;
    }

    /**
     * Get the arguments property: The final function call arguments as a complete JSON string.
     *
     * @return the arguments value.
     */
    @Generated
    public String getArguments() {
        return this.arguments;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeStringField("arguments", this.arguments);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesStreamEventFunctionCallArgumentsDone from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesStreamEventFunctionCallArgumentsDone if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResponsesStreamEventFunctionCallArgumentsDone.
     */
    @Generated
    public static ResponsesStreamEventFunctionCallArgumentsDone fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            String arguments = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                } else if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                } else if ("arguments".equals(fieldName)) {
                    arguments = reader.getString();
                } else if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ResponsesStreamEventFunctionCallArgumentsDone deserializedResponsesStreamEventFunctionCallArgumentsDone
                = new ResponsesStreamEventFunctionCallArgumentsDone(itemId, outputIndex, arguments);
            deserializedResponsesStreamEventFunctionCallArgumentsDone.type = type;
            return deserializedResponsesStreamEventFunctionCallArgumentsDone;
        });
    }
}
