// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai.responses.models;

/**
 * Defines values for ResponsesToolChoiceOption.
 */
public enum ResponsesToolChoiceOption {
    /**
     * Enum value none.
     */
    NONE("none"),

    /**
     * Enum value auto.
     */
    AUTO("auto"),

    /**
     * Enum value required.
     */
    REQUIRED("required");

    /**
     * The actual serialized value for a ResponsesToolChoiceOption instance.
     */
    private final String value;

    ResponsesToolChoiceOption(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ResponsesToolChoiceOption instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ResponsesToolChoiceOption object, or null if unable to parse.
     */
    public static ResponsesToolChoiceOption fromString(String value) {
        if (value == null) {
            return null;
        }
        ResponsesToolChoiceOption[] items = ResponsesToolChoiceOption.values();
        for (ResponsesToolChoiceOption item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
