// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.responses.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponsesWebSearchTool model.
 */
@Fluent
public final class ResponsesWebSearchTool extends ResponsesTool {

    /*
     * The type property.
     */
    @Generated
    private ResponsesToolType type = ResponsesToolType.WEB_SEARCH;

    /*
     * The user_location property.
     */
    @Generated
    private ResponsesWebSearchLocation userLocation;

    /*
     * The search_context_size property.
     */
    @Generated
    private ResponsesWebSearchContextSize searchContextSize;

    /**
     * Creates an instance of ResponsesWebSearchTool class.
     */
    @Generated
    public ResponsesWebSearchTool() {
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    /**
     * Get the userLocation property: The user_location property.
     *
     * @return the userLocation value.
     */
    @Generated
    public ResponsesWebSearchLocation getUserLocation() {
        return this.userLocation;
    }

    /**
     * Set the userLocation property: The user_location property.
     *
     * @param userLocation the userLocation value to set.
     * @return the ResponsesWebSearchTool object itself.
     */
    @Generated
    public ResponsesWebSearchTool setUserLocation(ResponsesWebSearchLocation userLocation) {
        this.userLocation = userLocation;
        return this;
    }

    /**
     * Get the searchContextSize property: The search_context_size property.
     *
     * @return the searchContextSize value.
     */
    @Generated
    public ResponsesWebSearchContextSize getSearchContextSize() {
        return this.searchContextSize;
    }

    /**
     * Set the searchContextSize property: The search_context_size property.
     *
     * @param searchContextSize the searchContextSize value to set.
     * @return the ResponsesWebSearchTool object itself.
     */
    @Generated
    public ResponsesWebSearchTool setSearchContextSize(ResponsesWebSearchContextSize searchContextSize) {
        this.searchContextSize = searchContextSize;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("user_location", this.userLocation);
        jsonWriter.writeStringField("search_context_size",
            this.searchContextSize == null ? null : this.searchContextSize.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponsesWebSearchTool from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponsesWebSearchTool if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponsesWebSearchTool.
     */
    @Generated
    public static ResponsesWebSearchTool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponsesWebSearchTool deserializedResponsesWebSearchTool = new ResponsesWebSearchTool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.type = ResponsesToolType.fromString(reader.getString());
                } else if ("user_location".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.userLocation = ResponsesWebSearchLocation.fromJson(reader);
                } else if ("search_context_size".equals(fieldName)) {
                    deserializedResponsesWebSearchTool.searchContextSize
                        = ResponsesWebSearchContextSize.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResponsesWebSearchTool;
        });
    }
}
