/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionDataSourceResponseCitation;
import com.azure.ai.openai.models.AzureChatExtensionRetrievedDocument;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureChatExtensionsMessageContext
implements JsonSerializable<AzureChatExtensionsMessageContext> {
    private List<AzureChatExtensionDataSourceResponseCitation> citations;
    private String intent;
    private List<AzureChatExtensionRetrievedDocument> allRetrievedDocuments;

    private AzureChatExtensionsMessageContext() {
    }

    public List<AzureChatExtensionDataSourceResponseCitation> getCitations() {
        return this.citations;
    }

    public String getIntent() {
        return this.intent;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("citations", this.citations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("intent", this.intent);
        jsonWriter.writeArrayField("all_retrieved_documents", this.allRetrievedDocuments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureChatExtensionsMessageContext fromJson(JsonReader jsonReader) throws IOException {
        return (AzureChatExtensionsMessageContext)jsonReader.readObject(reader -> {
            AzureChatExtensionsMessageContext deserializedAzureChatExtensionsMessageContext = new AzureChatExtensionsMessageContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("citations".equals(fieldName)) {
                    List citations;
                    deserializedAzureChatExtensionsMessageContext.citations = citations = reader.readArray(reader1 -> AzureChatExtensionDataSourceResponseCitation.fromJson(reader1));
                    continue;
                }
                if ("intent".equals(fieldName)) {
                    deserializedAzureChatExtensionsMessageContext.intent = reader.getString();
                    continue;
                }
                if ("all_retrieved_documents".equals(fieldName)) {
                    List allRetrievedDocuments;
                    deserializedAzureChatExtensionsMessageContext.allRetrievedDocuments = allRetrievedDocuments = reader.readArray(reader1 -> AzureChatExtensionRetrievedDocument.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureChatExtensionsMessageContext;
        });
    }

    public List<AzureChatExtensionRetrievedDocument> getAllRetrievedDocuments() {
        return this.allRetrievedDocuments;
    }
}

