/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.experimental.util.tracing;

import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LoggingEventBuilder;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.core.util.tracing.TracingLink;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class LoggingTracerProvider
implements TracerProvider {
    private static final TracingOptions DEFAULT_OPTIONS = new TracingOptions().setEnabled(false);

    public Tracer createTracer(String libraryName, String libraryVersion, String azNamespace, TracingOptions options) {
        return new LoggingTracer(options instanceof LoggingTracingOptions ? options : DEFAULT_OPTIONS);
    }

    private static class LoggingTracer
    implements Tracer {
        private final boolean isEnabled;

        LoggingTracer(TracingOptions options) {
            this.isEnabled = options.isEnabled();
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public Context start(String name, Context context) {
            if (!this.isEnabled) {
                return context;
            }
            LoggingSpan span = new LoggingSpan(name, SpanKind.INTERNAL, this.getSpan(context));
            return context.addData((Object)"span", (Object)span);
        }

        public Context start(String name, StartSpanOptions options, Context context) {
            if (!this.isEnabled) {
                return context;
            }
            LoggingSpan span = new LoggingSpan(name, options.getSpanKind(), this.getSpan(context));
            if (options.getAttributes() != null) {
                options.getAttributes().forEach((k, v) -> span.addKeyValue((String)k, v));
            }
            span.addKeyValue("startTimestamp", options.getStartTimestamp());
            if (options.getLinks() != null) {
                for (int i = 0; i < options.getLinks().size(); ++i) {
                    TracingLink link = (TracingLink)options.getLinks().get(i);
                    span.addKeyValue("link[" + i + "].traceId", link.getContext().getData((Object)"traceId").orElse(null));
                    span.addKeyValue("link[" + i + "].spanId", link.getContext().getData((Object)"spanId").orElse(null));
                    if (link.getAttributes() == null) continue;
                    for (Map.Entry attribute : link.getAttributes().entrySet()) {
                        span.addKeyValue("link[" + i + "]." + (String)attribute.getKey(), attribute.getValue());
                    }
                }
            }
            return context.addData((Object)"span", (Object)span);
        }

        public void end(String errorMessage, Throwable throwable, Context context) {
            if (this.isEnabled) {
                LoggingSpan span = this.getSpan(context);
                span.addKeyValue("status", errorMessage);
                span.end(throwable);
            }
        }

        public void setAttribute(String key, String value, Context context) {
            this.getSpan(context).addKeyValue(key, value);
        }

        public void setAttribute(String key, long value, Context context) {
            this.getSpan(context).addKeyValue(key, value);
        }

        public void injectContext(BiConsumer<String, String> headerSetter, Context context) {
            LoggingSpan span = this.getSpan(context);
            headerSetter.accept("traceparent", String.format("00-%s-%s-01", span.getTraceId(), span.getSpanId()));
        }

        public Context extractContext(Function<String, String> headerGetter) {
            String traceparent = headerGetter.apply("traceparent");
            if (traceparent == null) {
                return Context.NONE;
            }
            return new Context((Object)"traceId", (Object)traceparent.substring(3, 35)).addData((Object)"spanId", (Object)traceparent.substring(36, 52));
        }

        private LoggingSpan getSpan(Context context) {
            Object span;
            if (this.isEnabled && context != null && (span = context.getData((Object)"span").orElse(null)) != null) {
                return span;
            }
            return LoggingSpan.NOOP;
        }
    }

    public static class LoggingTracingOptions
    extends TracingOptions {
        public LoggingTracingOptions() {
            super(LoggingTracerProvider.class);
        }
    }

    static final class LoggingSpan {
        public static final LoggingSpan NOOP = new LoggingSpan();
        private static final ClientLogger LOGGER = new ClientLogger(LoggingSpan.class);
        private final String traceId;
        private final String spanId;
        private final LoggingEventBuilder log;
        private final boolean enabled;

        private LoggingSpan() {
            this.traceId = null;
            this.spanId = null;
            this.log = null;
            this.enabled = false;
        }

        public String getTraceId() {
            return this.enabled ? this.traceId : "00000000000000000000000000000000";
        }

        public String getSpanId() {
            return this.enabled ? this.spanId : "0000000000000000";
        }

        LoggingSpan(String name, SpanKind kind, String traceId, String parentSpanId) {
            this.traceId = traceId != null ? traceId : LoggingSpan.getRandomId(32);
            this.spanId = LoggingSpan.getRandomId(16);
            this.log = LOGGER.atInfo().addKeyValue("traceId", this.traceId).addKeyValue("spanId", this.spanId).addKeyValue("parentSpanId", parentSpanId).addKeyValue("name", name).addKeyValue("kind", kind.name());
            this.log.log("span created");
            this.enabled = true;
        }

        LoggingSpan(String name, SpanKind kind, LoggingSpan parent) {
            this(name, kind, parent.enabled ? parent.traceId : null, parent.getSpanId());
        }

        public LoggingSpan addKeyValue(String key, Object value) {
            if (this.enabled) {
                this.log.addKeyValue(key, value);
            }
            return this;
        }

        public void end(Throwable throwable) {
            if (this.enabled) {
                if (throwable != null) {
                    this.log.log("span ended", new Object[]{throwable});
                } else {
                    this.log.log("span ended");
                }
            }
        }

        private static String getRandomId(int length) {
            return CoreUtils.randomUuid().toString().replace("-", "").substring(32 - length);
        }
    }
}

