/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cache;

import com.digiwin.app.cache.DWCacheKeyGenerator;
import java.io.InputStream;
import java.time.Duration;
import java.util.HashMap;
import java.util.Properties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Profile(value={"openCache"})
@Configuration
public class DWCacheConfiguration
extends CachingConfigurerSupport {
    @Bean(name={"cacheManager"})
    public RedisCacheManager cacheManager(RedisConnectionFactory connectionFactory) throws Exception {
        ClassLoader classLoader = DWCacheConfiguration.class.getClassLoader();
        Properties properties = new Properties();
        try (InputStream inputStream = classLoader.getResourceAsStream("dw-cache.properties");){
            properties.load(inputStream);
        }
        String keyExpiredTime = properties.getProperty("keyExpiredTime");
        RedisCacheConfiguration conf_dwapiplatform = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMillis(Long.parseLong(keyExpiredTime)));
        HashMap<String, RedisCacheConfiguration> cacheConfigurations = new HashMap<String, RedisCacheConfiguration>();
        cacheConfigurations.put("dwapiplatform", conf_dwapiplatform);
        return RedisCacheManager.RedisCacheManagerBuilder.fromConnectionFactory((RedisConnectionFactory)connectionFactory).withInitialCacheConfigurations(cacheConfigurations).build();
    }

    @Bean(value={"dwCacheKeyGenerator"})
    public KeyGenerator keyGenerator() {
        return new DWCacheKeyGenerator();
    }
}

