/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cache;

import com.digiwin.app.cache.DWCacheable;
import com.digiwin.app.service.DWServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.springframework.cache.interceptor.KeyGenerator;

public class DWCacheKeyGenerator
implements KeyGenerator {
    public Object generate(Object target, Method method, Object ... params) {
        String dwCacheableValue = null;
        DWCacheable[] dwCacheables = (DWCacheable[])method.getAnnotationsByType(DWCacheable.class);
        if (dwCacheables != null && dwCacheables.length > 0) {
            DWCacheable dwCacheable = dwCacheables[0];
            dwCacheableValue = dwCacheable.value();
        }
        return DWCacheKeyGenerator.generateKey(dwCacheableValue, params);
    }

    public static Object generateKey(String dwCacheableValue, Object ... params) {
        boolean isUserTokenCache = false;
        if ("token".equals(dwCacheableValue)) {
            isUserTokenCache = true;
        }
        String key = null;
        if (isUserTokenCache) {
            key = params[0].toString();
        } else if (dwCacheableValue != null && dwCacheableValue.trim().length() > 0) {
            key = dwCacheableValue;
            if (key.contains("{token}")) {
                String token = DWServiceContext.getContext().getToken();
                key = key.replaceAll("\\{token\\}", token);
            }
            if (key.contains("{appId}")) {
                Properties properties = new Properties();
                ClassLoader classLoader = DWCacheKeyGenerator.class.getClassLoader();
                try (InputStream inputStream = classLoader.getResourceAsStream("bootstrap.properties");){
                    properties.load(inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String appId = properties.getProperty("spring.application.name");
                key = key.replaceAll("\\{appId\\}", appId);
            }
        } else {
            key = "no_defined";
        }
        return key;
    }
}

