/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.module.DWModuleInfoProvider;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.util.List;
import java.util.Map;

public class DWLocalServiceRepository
implements DWServiceRepository {
    protected Map<String, List<DWServiceInfo>> _services;

    public DWLocalServiceRepository() {
        this.initialize();
    }

    public DWService getService(DWHeader header, DWMethod method) throws Exception {
        DWServiceInfo serviceInfo = this.getServiceInfo(header);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getInstance();
    }

    public void refresh(String moduleName) {
        List implementations = DWModuleInfoProvider.getImplementationInfos((String)moduleName, (boolean)true);
        DWModuleInfoProvider.getImplementationInfos().put(moduleName, implementations);
        this._services = DWModuleInfoProvider.getImplementationInfos();
    }

    private DWServiceInfo getServiceInfo(DWHeader header) {
        DWServiceInfo targetServiceInfo = null;
        String moduleName = header.getModuleName();
        List<DWServiceInfo> services = this._services.get(moduleName);
        if (services != null) {
            for (DWServiceInfo serviceInfo : services) {
                if (serviceInfo.getInterfaceType() != header.getServiceType()) continue;
                targetServiceInfo = serviceInfo;
                break;
            }
        }
        return targetServiceInfo;
    }

    private void initialize() {
        this._services = DWModuleInfoProvider.getImplementationInfos();
    }
}

