/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWRestfulHeader;
import com.digiwin.app.module.DWModuleInfoProvider;
import com.digiwin.app.service.restful.DWRestfulService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLocalHeaderRepository
implements DWHeaderRepository {
    static Log log = LogFactory.getLog(DWLocalHeaderRepository.class);
    protected List<DWHeader> _headers;

    public DWLocalHeaderRepository() {
        this.initialize();
    }

    public List<DWHeader> getAllHeader() {
        return this._headers;
    }

    public void refresh(String moduleName) {
        log.info((Object)("refresh local headers repository of the module, modlue name: " + moduleName));
        List moduleInterfaceList = DWModuleInfoProvider.getInterfaceInfos((String)moduleName, (boolean)true);
        for (Class interfaceType : moduleInterfaceList) {
            this.removeHeader(interfaceType);
            this.registerDWHeader(moduleName, interfaceType);
        }
        this.log();
    }

    private void initialize() {
        this._headers = new ArrayList<DWHeader>();
        Map interfaceList = DWModuleInfoProvider.getInterfaceInfos();
        for (Map.Entry entry : interfaceList.entrySet()) {
            String moduleName = (String)entry.getKey();
            List moduleInterfaceList = (List)entry.getValue();
            for (Class interfaceType : moduleInterfaceList) {
                this.registerDWHeader(moduleName, interfaceType);
            }
        }
        this.log();
    }

    private void registerDWHeader(String moduleName, Class<?> interfaceType) {
        String serviceName = interfaceType.getSimpleName();
        if (interfaceType.isAnnotationPresent(DWRestfulService.class)) {
            DWRestfulHeader restfulHeader = new DWRestfulHeader(moduleName, serviceName, interfaceType);
            this._headers.add((DWHeader)restfulHeader);
            return;
        }
        DWHeader header = new DWHeader(moduleName, serviceName, interfaceType);
        this._headers.add(header);
    }

    private void log() {
        StringBuilder message = new StringBuilder();
        int i = 0;
        for (DWHeader header : this._headers) {
            message.setLength(0);
            message.append(">>> Found Header ").append(++i).append(".");
            message.append("module=").append(header.getModuleName());
            message.append(", service name=").append(header.getServiceName());
            message.append(", type=").append(header.getServiceType().getName());
            log.info((Object)message.toString());
        }
    }

    private void removeHeader(Class<?> interfaceType) {
        Iterator<DWHeader> iterator = this._headers.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            DWHeader header = iterator.next();
            if (StringUtils.equals((CharSequence)header.getServiceType().getName(), (CharSequence)interfaceType.getName())) {
                iterator.remove();
            }
            ++count;
        }
    }

    public List<DWHeader> getHeaders(String moduleName) {
        ArrayList<DWHeader> result = new ArrayList<DWHeader>();
        for (DWHeader header : this._headers) {
            if (!StringUtils.equals((CharSequence)header.getModuleName(), (CharSequence)moduleName)) continue;
            result.add(header);
        }
        return result;
    }
}

