/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.iam.HttpRequestModel;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpConnectionManager {
    public static CloseableHttpClient httpClient;

    public static synchronized void init(final HttpRequestModel requestModel) {
        if (httpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(requestModel.getMaxTotalConnections());
            connectionManager.setMaxTotal(requestModel.getMaxTotalConnections());
            DefaultConnectionKeepAliveStrategy keepAliveStrategy = new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAlive = super.getKeepAliveDuration(response, context);
                    long customKeepAlive = requestModel.getKeepAliveTimeout();
                    if (customKeepAlive <= -1L) {
                        return keepAlive;
                    }
                    if (keepAlive <= -1L) {
                        return customKeepAlive;
                    }
                    return keepAlive > customKeepAlive ? customKeepAlive : keepAlive;
                }
            };
            RequestConfig config = RequestConfig.custom().setSocketTimeout(requestModel.getSoTimeout()).setConnectTimeout(requestModel.getConnectionTimeout()).setConnectionRequestTimeout(requestModel.getConnectionPoolRequestTimeout()).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)keepAliveStrategy).build();
        }
    }

    public static CloseableHttpClient getHttpClient(HttpRequestModel requestModel) {
        if (httpClient == null) {
            HttpConnectionManager.init(requestModel);
        }
        return httpClient;
    }
}

