/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMConfig;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IAMHttpRequester {
    private static boolean tenantEnabled = new Boolean(System.getProperty("server.tenant"));
    private static String tokenMode = System.getProperty("server.http.tokenmode");

    public static Object submit(ServiceModel model) throws Exception {
        Map<String, String> requestHeader = IAMHttpRequester.createRequestHeader(model);
        String requestBody = IAMHttpRequester.createRequestBody(model.getParams());
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(requestHeader);
        requestModel.setRequestMethod(model.getRequestMethod());
        requestModel.setUrl(IAMConfig.getValue("iam.url") + model.getInvokeURL());
        HttpResponseModel responseModel = HttpRequester.submitRequest(requestModel);
        int httpStatusCode = responseModel.getHttpStatusCode();
        if (httpStatusCode != 200) {
            IAMHttpRequester.handleHttpStatus(httpStatusCode);
        }
        return responseModel;
    }

    public static HttpRequestModel getHttpRequestModel() {
        HttpRequestModel requestModel = new HttpRequestModel();
        requestModel.setContentType(IAMConfig.getValue("iam.contentType"));
        requestModel.setCharSet(IAMConfig.getValue("iam.charset"));
        requestModel.setConnectionPoolRequestTimeout(Integer.parseInt(IAMConfig.getValue("iam.httpConnectionPoolRequestTimeout")));
        requestModel.setConnectionTimeout(Integer.parseInt(IAMConfig.getValue("iam.httpConnectionTimeout")));
        requestModel.setSoTimeout(Integer.parseInt(IAMConfig.getValue("iam.soTimeout")));
        requestModel.setEncode(IAMConfig.getValue("iam.encode"));
        requestModel.setMaxTotalConnections(Integer.parseInt(IAMConfig.getValue("iam.httpMaxConnections")));
        requestModel.setKeepAliveTimeout(Long.parseLong(IAMConfig.getValue("iam.keepAliveTimeout")));
        return requestModel;
    }

    public static String createRequestBody(Map<String, Object> params) throws Exception {
        Gson jsonParser = new Gson();
        String content = jsonParser.toJson(params);
        return content;
    }

    public static Map<String, String> createRequestHeader(ServiceModel model) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", IAMConfig.getValue("iam.contentType") + ";" + IAMConfig.getValue("iam.charset"));
        String iamApToken = DWResourceUtils.getProperties((String)"dw-iam.properties").getProperty("iam.apToken");
        if (iamApToken.isEmpty()) {
            iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", "");
        }
        header.put("digi-middleware-auth-app", iamApToken);
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals("IAM")) {
            header.put("digi-middleware-auth-user", model.getToken());
        }
        return header;
    }

    public static void handleHttpStatus(int httpStatusCode) throws Exception {
        if (httpStatusCode == 500) {
            throw new Exception("IAM \u7cfb\u7edf\u9519\u8bef\uff0c\u66f4\u591a\u8d44\u8baf\u8bf7\u67e5\u8be2\u7cfb\u7edf\u8bb0\u5f55!");
        }
        if (httpStatusCode == 503) {
            throw new Exception("IAM \u5916\u90e8\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u65e0\u6cd5\u8fde\u7ebf\u5230\u540e\u7aef\u8d44\u6599\u5e93!");
        }
        if (httpStatusCode == 406) {
            throw new Exception("IAM AP TOKEN \u932f\u8aa4!");
        }
    }
}

