/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtil {
    public static RSAKeys generateRSAKeys() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new RSAKeys(privateKey, publicKey);
    }

    public static RSAPrivateKey getRSAPrivateKey(byte[] byteArray) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(byteArray);
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static RSAPublicKey getRSAPublicKey(byte[] byteArray) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(byteArray);
        RSAPublicKey publicKey = (RSAPublicKey)((Object)keyFactory.generatePrivate(keySpec));
        return publicKey;
    }

    public static byte[] encrypt(RSAPublicKey publicKey, byte[] srcBytes) throws Exception {
        if (publicKey == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        byte[] resultBytes = cipher.doFinal(srcBytes);
        return resultBytes;
    }

    public static byte[] decrypt(RSAPrivateKey privateKey, byte[] srcBytes) throws Exception {
        if (privateKey == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        byte[] resultBytes = cipher.doFinal(srcBytes);
        return resultBytes;
    }

    public static class RSAKeys {
        private RSAPrivateKey privateKey;
        private RSAPublicKey publicKey;

        public RSAKeys(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public RSAPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public RSAPublicKey getPublicKey() {
            return this.publicKey;
        }
    }
}

