/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.utils.DWModuleConfigFileScanHelper;
import com.digiwin.app.module.utils.DWProfileScanHelper;
import com.digiwin.app.module.utils.DWServiceScanHelper;
import java.util.List;
import java.util.Map;

public class DWModuleInfoProvider {
    private static Map<String, List<Class<?>>> _interfaces;
    private static Map<String, List<DWServiceInfo>> _implementations;

    public static Map<String, List<Class<?>>> getInterfaceInfos() {
        return _interfaces;
    }

    public static Map<String, List<DWServiceInfo>> getImplementationInfos() {
        return _implementations;
    }

    public static List<Class<?>> getInterfaceInfos(String moduleName) {
        return DWModuleInfoProvider.getInterfaceInfos(moduleName, false);
    }

    public static List<DWServiceInfo> getImplementationInfos(String moduleName) {
        return DWModuleInfoProvider.getImplementationInfos(moduleName, false);
    }

    public static List<Class<?>> getInterfaceInfos(String moduleName, boolean refreshable) {
        if (refreshable) {
            DWModuleClassLoader.removeModuleClassLoader(moduleName);
            DWModuleSpringUtils.refresh(moduleName);
            DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper();
            Map interfaces = (Map)interfaceScanHelper.scan(moduleName);
            return (List)interfaces.get(moduleName);
        }
        return _interfaces.get(moduleName);
    }

    public static List<DWServiceInfo> getImplementationInfos(String moduleName, boolean refreshable) {
        if (refreshable) {
            DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper();
            Map implementations = (Map)implementationScanHelper.scan(moduleName);
            return (List)implementations.get(moduleName);
        }
        return _implementations.get(moduleName);
    }

    static {
        DWProfileScanHelper interfaceScanHelper = new DWProfileScanHelper();
        _interfaces = (Map)interfaceScanHelper.scan();
        DWServiceScanHelper implementationScanHelper = new DWServiceScanHelper();
        _implementations = (Map)implementationScanHelper.scan();
        DWModuleConfigFileScanHelper configFileHelper = new DWModuleConfigFileScanHelper();
        configFileHelper.scan();
    }
}

