/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module;

import com.digiwin.app.container.exceptions.DWModuleSusspendedException;
import com.digiwin.app.container.exceptions.DWServiceSusspendedException;
import com.digiwin.app.module.DWServiceInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class DWModuleSusspendedInvocationHandler
implements InvocationHandler {
    private String moduleName;
    private String serviceName;
    private Throwable cause;

    protected DWModuleSusspendedInvocationHandler(DWServiceInfo serviceInfo, Throwable cause) {
        this.moduleName = serviceInfo.getModuleName();
        this.serviceName = serviceInfo.getInterfaceType().getName();
        this.cause = cause;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable rootCause;
        boolean modulseSusspended = false;
        if (this.cause instanceof DWModuleSusspendedException) {
            rootCause = ((DWModuleSusspendedException)this.cause).getSusspendCause();
            modulseSusspended = true;
        } else {
            rootCause = this.cause;
        }
        StringBuilder message = new StringBuilder();
        message.append("Service [").append(this.serviceName).append("]").append(" has been suspended ");
        if (modulseSusspended) {
            message.append("due to Module [").append(this.moduleName).append("] loading failed!");
        } else {
            message.append("due to creating failed!");
        }
        message.append(System.lineSeparator()).append("!possible reason> ").append(rootCause.getMessage());
        DWServiceSusspendedException exception = new DWServiceSusspendedException(message.toString(), rootCause);
        exception.getInstructors().put("solution", "Find the error setting file, then fix it!");
        throw exception;
    }
}

