/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring;

import com.digiwin.app.container.exceptions.DWModuleSusspendedException;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.module.spring.scanner.SpringConfigScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public final class DWModuleSpringUtils {
    private static Log _log = LogFactory.getLog(DWModuleSpringUtils.class);
    private static Map<String, ApplicationContext> _moduleContexts = new HashMap<String, ApplicationContext>();
    private static Map<String, String[]> _moduleSpringConfigs = new HashMap<String, String[]>();
    private static Map<String, Exception> _springConfigLoadFailedModuleList = new HashMap<String, Exception>();
    private static List<SpringConfigScanner> springConfigScanners = new ArrayList<SpringConfigScanner>();

    public DWModuleSpringUtils(List<SpringConfigScanner> springConfigScanners) {
        DWModuleSpringUtils.springConfigScanners = springConfigScanners;
        this.doScan();
    }

    private static void doScan() {
        for (SpringConfigScanner springConfigScanner : springConfigScanners) {
            Map<String, String[]> moduleSpringConfig = springConfigScanner.doScan();
            _moduleSpringConfigs.putAll(moduleSpringConfig);
        }
    }

    private static void doScan(String moduleName) {
        for (SpringConfigScanner springConfigScanner : springConfigScanners) {
            Map<String, String[]> moduleSpringConfig = springConfigScanner.doScan(moduleName);
            _moduleSpringConfigs.putAll(moduleSpringConfig);
        }
    }

    public static synchronized ApplicationContext getModuleSpringContext(String moduleName) {
        if (_springConfigLoadFailedModuleList.containsKey(moduleName)) {
            DWModuleSpringUtils.throwModuleSusspendException(moduleName, _springConfigLoadFailedModuleList.get(moduleName));
        }
        if (_moduleContexts.containsKey(moduleName)) {
            return _moduleContexts.get(moduleName);
        }
        String[] configs = _moduleSpringConfigs.get(moduleName);
        FileSystemXmlApplicationContext context = null;
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
            context = new FileSystemXmlApplicationContext(configs, false, SpringContextUtils.getContext());
            context.setClassLoader((ClassLoader)classLoader);
            try {
                context.refresh();
            }
            catch (Exception e) {
                _springConfigLoadFailedModuleList.put(moduleName, e);
                _log.error((Object)("Module Config Load failed! moduleName = " + moduleName), (Throwable)e);
                DWModuleSpringUtils.throwModuleSusspendException(moduleName, e);
            }
        }
        _moduleContexts.put(moduleName, (ApplicationContext)context);
        return context;
    }

    public static <T> T getBean(Object moduleService, String name) {
        ClassLoader loader = moduleService.getClass().getClassLoader();
        String moduleName = DWModuleClassLoader.getModuleName(loader);
        ApplicationContext moduleContext = DWModuleSpringUtils.getModuleSpringContext(moduleName);
        if (moduleContext == null) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("This Module '").append(moduleName).append("'").append(" has not set any Spring Configurations.");
            throw new IllegalStateException(errorMessage.toString());
        }
        Object bean = moduleContext.getBean(name);
        if (bean == null) {
            return null;
        }
        return (T)bean;
    }

    private static void throwModuleSusspendException(String moduleName, Throwable cause) {
        throw new DWModuleSusspendedException(moduleName, cause);
    }

    public static Map<String, String[]> getSpringConfigs() {
        return _moduleSpringConfigs;
    }

    public static Map<String, ApplicationContext> getSpringContexts() {
        return _moduleContexts;
    }

    public static void refresh(String moduleName) {
        _moduleContexts.remove(moduleName);
        _springConfigLoadFailedModuleList.remove(moduleName);
        DWModuleSpringUtils.doScan(moduleName);
    }
}

