/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring.scanner;

import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.spring.scanner.SpringConfigScanner;
import com.digiwin.app.module.utils.DWModuleResourceUtils;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import com.digiwin.app.module.utils.DWResourceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DWModuleSpringConfigScanner
extends DWModuleScanHelper<Map<String, String[]>>
implements SpringConfigScanner {
    public DWModuleSpringConfigScanner() {
        super(DWResourceUtils.getFolderServicePath(), "xml");
    }

    @Override
    protected Map<String, String[]> createScanContext() {
        return new HashMap<String, String[]>();
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, Map<String, String[]> scanContext) {
        List<String> springConfigFileNames = this.scanModuleSpringConfigFileNames(moduleName);
        block0: for (DWModuleFileInfo fileInfo : fileInfoList) {
            File[] files = fileInfo.getFiles();
            if (!springConfigFileNames.isEmpty()) continue;
            for (int i = 0; i < files.length; ++i) {
                if (!"spring-config.xml".equals(files[i].getName().toLowerCase())) continue;
                springConfigFileNames.add("classpath:spring-config.xml");
                continue block0;
            }
        }
        String[] fileNames = new String[springConfigFileNames.size()];
        springConfigFileNames.toArray(fileNames);
        scanContext.put(moduleName, fileNames);
    }

    private List<String> scanModuleSpringConfigFileNames(String moduleName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        String propertiesName = moduleName + ".properties";
        Properties moduleProperties = DWModuleResourceUtils.getProperties(moduleName, propertiesName);
        String springConfigFileName = moduleProperties.getProperty("springconfigfilename");
        if (springConfigFileName == null || springConfigFileName.isEmpty()) {
            return fileNames;
        }
        String[] springConfigFileNames = springConfigFileName.split(",");
        for (int i = 0; i < springConfigFileNames.length; ++i) {
            String eachConfigFileName = springConfigFileNames[i];
            String configPath = "classpath:" + eachConfigFileName;
            fileNames.add(configPath);
        }
        return fileNames;
    }

    @Override
    public Map<String, String[]> doScan() {
        return (Map)this.scan();
    }

    @Override
    public Map<String, String[]> doScan(String moduleName) {
        return (Map)this.scan(moduleName);
    }
}

