/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWModuleScanHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWModuleClassScanHelper<T>
extends DWModuleScanHelper<T> {
    protected static Log _log = LogFactory.getLog(DWModuleClassScanHelper.class);

    public DWModuleClassScanHelper(String folderName) {
        super(folderName, "jar");
    }

    protected abstract void onClassScan(String var1, DWModuleClassLoader var2, String var3, Class<?> var4, T var5);

    protected DWModuleClassLoader getClassLoader(String moduleName, File[] jarFiles) {
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
        if (classLoader == null) {
            ClassLoader parent = this.getClass().getClassLoader();
            classLoader = new DWModuleClassLoader(parent);
            DWModuleClassLoader.addModuleClassLoader(moduleName, classLoader);
        }
        for (File f : jarFiles) {
            try {
                URL url = f.toURI().toURL();
                classLoader.addServiceJarURL(url);
            }
            catch (Exception e) {
                _log.error((Object)("module=" + moduleName + ", file=" + f.getName() + " can't add to class loader!"), (Throwable)e);
            }
        }
        return classLoader;
    }

    protected DWModuleClassLoader getClassLoader(String moduleName, DWModuleFileInfo fileInfo) {
        File[] jarFiles;
        String directoryName = fileInfo.getDirectoryLayer();
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByExactName(directoryName);
        if (classLoader == null) {
            String parentDirectoryName = fileInfo.getParentDirectoryLayer();
            ClassLoader parent = DWModuleClassLoader.getModuleClassLoaderByExactName(parentDirectoryName);
            if (parent == null) {
                parent = this.getClass().getClassLoader();
            }
            classLoader = new DWModuleClassLoader(parent);
            DWModuleClassLoader.addModuleClassLoader(moduleName, classLoader, fileInfo);
        } else {
            File directoryFile = fileInfo.getDirectoryFile();
            if (directoryFile != null) {
                try {
                    classLoader.addServiceJarURL(directoryFile.toURI().toURL());
                }
                catch (MalformedURLException parent) {
                    // empty catch block
                }
            }
        }
        for (File f : jarFiles = fileInfo.getFiles()) {
            try {
                URL url = f.toURI().toURL();
                classLoader.addServiceJarURL(url);
            }
            catch (Exception e) {
                _log.error((Object)("module=" + moduleName + ", file=" + f.getName() + " can't add to class loader!"), (Throwable)e);
            }
        }
        return classLoader;
    }

    @Override
    protected void onModuleScan(String moduleName, List<DWModuleFileInfo> fileInfoList, T scanContext) {
        for (DWModuleFileInfo fileInfo : fileInfoList) {
            File[] files = fileInfo.getFiles();
            DWModuleClassLoader classLoader = this.getClassLoader(moduleName, fileInfo);
            for (File file : files) {
                try {
                    JarFile jarFile = new JarFile(file);
                    this.onJarScan(moduleName, jarFile, classLoader, scanContext);
                }
                catch (Exception e) {
                    this.onJarScanFiled(moduleName, file, e);
                }
            }
        }
    }

    protected void onJarScan(String moduleName, JarFile jarFile, DWModuleClassLoader classLoader, T scanContext) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
            String className = jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6);
            try {
                Class<?> clazz = classLoader.loadClass(className);
                this.onClassScan(moduleName, classLoader, jarFile.getName(), clazz, scanContext);
            }
            catch (Throwable e) {
                this.onClassScanFailed(moduleName, jarFile, className, e);
            }
        }
        try {
            jarFile.close();
        }
        catch (Exception e) {
            _log.error((Object)("file=" + jarFile.getName() + " can't close properly!"), (Throwable)e);
        }
    }

    protected void onJarScanFiled(String moduleName, File file, Exception e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName()).append(" scan failed!");
        _log.error((Object)message.toString(), (Throwable)e);
    }

    protected void onClassScanFailed(String moduleName, JarFile file, String className, Throwable e) {
        StringBuilder message = new StringBuilder();
        message.append("[").append(moduleName).append("]");
        message.append(" jar=").append(file.getName());
        message.append(" class=").append(className).append(" scan failed!");
        _log.info((Object)message);
        e.printStackTrace();
    }
}

