/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleFileInfo;
import com.digiwin.app.module.utils.DWResourceUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class DWModuleScanHelper<T> {
    private String _rootPath;
    private String _extensionName;

    public DWModuleScanHelper(String scanFolderPath, String extensionName) {
        if (scanFolderPath == null || scanFolderPath.isEmpty()) {
            throw new IllegalArgumentException("scanFolderPath is null or empty!");
        }
        this._rootPath = scanFolderPath;
        this._extensionName = extensionName;
    }

    public DWModuleScanHelper() {
    }

    public T scan() {
        File[] rootFileList;
        T scanContext = this.createScanContext();
        File rootDir = new File(this._rootPath);
        String lastFolderName = StringUtils.substringAfterLast((String)this._rootPath, (String)File.separator);
        String cutomizationRootPath = DWResourceUtils.getFolderCustomizationPath() + File.separator + lastFolderName;
        String industryRootPath = DWResourceUtils.getFolderIndsutryPath() + File.separator + lastFolderName;
        if (!rootDir.exists()) {
            return scanContext;
        }
        for (File file : rootFileList = rootDir.listFiles()) {
            if (!file.isDirectory()) continue;
            String moduleName = file.getName();
            File cutomizationModuleDir = new File(cutomizationRootPath + File.separator + moduleName);
            File industryModuleDir = new File(industryRootPath + File.separator + moduleName);
            ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
            String directoryLayer = moduleName;
            this.createModuleFileList(fileInfoList, file, directoryLayer);
            if (industryModuleDir.exists()) {
                directoryLayer = directoryLayer + File.separator + "industry";
                this.createModuleFileList(fileInfoList, industryModuleDir, directoryLayer);
            }
            if (cutomizationModuleDir.exists()) {
                directoryLayer = directoryLayer + File.separator + "customization";
                this.createModuleFileList(fileInfoList, cutomizationModuleDir, directoryLayer);
            }
            this.onModuleScan(moduleName, fileInfoList, scanContext);
        }
        return scanContext;
    }

    private void scan(T scanContext, File rootDir, String moduleName) {
    }

    private List<DWModuleFileInfo> createModuleFileList(List<DWModuleFileInfo> fileInfoList, File file, String directoryLayer) {
        FileFilter extensionFilter;
        FileFilter fileFilter = extensionFilter = this._extensionName == null ? null : DWModuleScanHelper.getExtensionFilter(this._extensionName);
        if (fileInfoList == null) {
            fileInfoList = new ArrayList<DWModuleFileInfo>();
        }
        File[] files = file.listFiles(extensionFilter);
        DWModuleFileInfo fileInfo = new DWModuleFileInfo(files, file);
        String parentDirectoryLayer = StringUtils.substringBeforeLast((String)directoryLayer, (String)"\\");
        fileInfo.setDirectoryLayer(directoryLayer);
        fileInfo.setParentDirectoryLayer(parentDirectoryLayer);
        fileInfoList.add(fileInfo);
        return fileInfoList;
    }

    public T scan(String moduleName) {
        if (moduleName == null || moduleName.isEmpty()) {
            throw new IllegalArgumentException("moduleName is null or empty!");
        }
        T scanContext = this.createScanContext();
        String lastFolderName = StringUtils.substringAfterLast((String)this._rootPath, (String)File.separator);
        String cutomizationRootPath = DWResourceUtils.getFolderCustomizationPath() + File.separator + lastFolderName;
        String industryRootPath = DWResourceUtils.getFolderIndsutryPath() + File.separator + lastFolderName;
        File cutomizationModuleDir = new File(cutomizationRootPath + File.separator + moduleName);
        File industryModuleDir = new File(industryRootPath + File.separator + moduleName);
        ArrayList<DWModuleFileInfo> fileInfoList = new ArrayList<DWModuleFileInfo>();
        String directoryLayer = moduleName;
        File moduleDir = new File(this._rootPath + File.separator + moduleName);
        this.createModuleFileList(fileInfoList, moduleDir, directoryLayer);
        if (industryModuleDir.exists()) {
            directoryLayer = directoryLayer + File.separator + "industry";
            this.createModuleFileList(fileInfoList, industryModuleDir, directoryLayer);
        }
        if (cutomizationModuleDir.exists()) {
            directoryLayer = directoryLayer + File.separator + "customization";
            this.createModuleFileList(fileInfoList, cutomizationModuleDir, directoryLayer);
        }
        this.onModuleScan(moduleName, fileInfoList, scanContext);
        return scanContext;
    }

    protected abstract T createScanContext();

    protected abstract void onModuleScan(String var1, List<DWModuleFileInfo> var2, T var3);

    private static FileFilter getExtensionFilter(final String extensionName) {
        if (extensionName == null || extensionName.isEmpty()) {
            return null;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith("." + extensionName);
            }
        };
        return filter;
    }
}

