/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.utils.DWModuleClassScanHelper;
import com.digiwin.app.module.utils.DWResourceUtils;
import com.digiwin.app.service.DWService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class DWProfileScanHelper
extends DWModuleClassScanHelper<Map<String, List<Class<?>>>> {
    private ModuleJarScanInfo moduleJarScanInfo = new ModuleJarScanInfo();

    public DWProfileScanHelper() {
        super(DWResourceUtils.getFolderHeaderPath());
    }

    @Override
    protected void onJarScan(String moduleName, JarFile jarFile, DWModuleClassLoader classLoader, Map<String, List<Class<?>>> scanContext) {
        super.onJarScan(moduleName, jarFile, classLoader, scanContext);
        String jarName = jarFile.getName();
        boolean isPrimaryJar = this.moduleJarScanInfo.isPrimaryJar(moduleName, jarName);
        if (isPrimaryJar) {
            List<String> classNameList = this.moduleJarScanInfo.getClassNameList(moduleName, jarName);
            for (String className : classNameList) {
                classLoader.addServiceInfo(className);
            }
        }
    }

    @Override
    protected void onClassScan(String moduleName, DWModuleClassLoader classLoader, String jarName, Class<?> clazz, Map<String, List<Class<?>>> scanContext) {
        this.moduleJarScanInfo.cacheClassInfo(moduleName, jarName, clazz.getName());
        if (!clazz.isInterface()) {
            return;
        }
        List<Class<?>> moduleInfos = scanContext.get(moduleName);
        Class<?>[] interfaces = clazz.getInterfaces();
        Class<?> oldVerInterface = null;
        for (Class<?> serviceInterface : interfaces) {
            if (serviceInterface != DWService.class) continue;
            if (moduleInfos == null) {
                moduleInfos = new ArrayList();
                scanContext.put(moduleName, moduleInfos);
            }
            for (Class<?> item : moduleInfos) {
                if (!clazz.getName().equals(item.getName())) continue;
                oldVerInterface = item;
                break;
            }
            if (oldVerInterface != null) {
                moduleInfos.remove(oldVerInterface);
            }
            moduleInfos.add(clazz);
            classLoader.addServiceInfo(clazz.getName());
            this.moduleJarScanInfo.addToPrimaryList(moduleName, jarName);
            break;
        }
    }

    @Override
    protected Map<String, List<Class<?>>> createScanContext() {
        this.moduleJarScanInfo.clear();
        return new HashMap();
    }

    private class ModuleJarScanInfo {
        private List<String> _primaryModuleJarList = new ArrayList<String>();
        private Map<String, List<String>> _scanInfo = new HashMap<String, List<String>>();

        private ModuleJarScanInfo() {
        }

        void cacheClassInfo(String moduleName, String jarName, String className) {
            String key = this.getKey(moduleName, jarName);
            List<String> classInfos = this._scanInfo.get(key);
            if (classInfos == null) {
                classInfos = new ArrayList<String>();
                this._scanInfo.put(key, classInfos);
            }
            classInfos.add(className);
        }

        String getKey(String moduleName, String jarName) {
            return moduleName + "_" + jarName;
        }

        void addToPrimaryList(String moduleName, String jarName) {
            String key = this.getKey(moduleName, jarName);
            if (!this._primaryModuleJarList.contains(key)) {
                this._primaryModuleJarList.add(key);
            }
        }

        boolean isPrimaryJar(String moduleName, String jarName) {
            String key = this.getKey(moduleName, jarName);
            return this._primaryModuleJarList.contains(key);
        }

        List<String> getClassNameList(String moduleName, String jarName) {
            String key = this.getKey(moduleName, jarName);
            return this._scanInfo.get(key);
        }

        void clear() {
            this._primaryModuleJarList.clear();
            this._scanInfo.clear();
        }
    }
}

