/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWResourceUtils {
    private static String FOLDER_HEADER_PATH;
    private static String FOLDER_SERVICE_PATH;
    private static String FOLDER_PROPERTIES_PATH;
    private static String FOLDER_INDUSTY_PATH;
    private static String FOLDER_CUSTOMIZATION_PATH;
    public static final String IMPLEMENTATION = "implementation";
    public static final String INTERFACE = "interface";
    public static final String INDUSTRY = "industry";
    public static final String CUSTOMIZATION = "customization";
    private static Log _log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String fileName) {
        Properties properties = new Properties();
        InputStream propertyInputStream = null;
        try {
            URL url = DWResourceUtils.getResourceURL(fileName);
            if (url != null) {
                propertyInputStream = url.openStream();
                properties.load(propertyInputStream);
            }
        }
        catch (Exception e) {
            _log.error((Object)("getProperties, open file failed -> " + fileName), (Throwable)e);
        }
        finally {
            if (propertyInputStream != null) {
                try {
                    propertyInputStream.close();
                }
                catch (IOException e) {
                    _log.error((Object)"propertyInputStream can't close properly!", (Throwable)e);
                }
            }
        }
        return properties;
    }

    public static URL getResourceURL(String resourceName) {
        File resourceFile = null;
        File propertiesFolder = new File(FOLDER_PROPERTIES_PATH);
        resourceFile = DWResourceUtils.getFileInFolder(propertiesFolder, resourceName);
        if (resourceFile == null) {
            resourceFile = DWResourceUtils.getFile(resourceName);
        }
        try {
            if (resourceFile != null) {
                return resourceFile.toURI().toURL();
            }
        }
        catch (Exception e) {
            _log.error((Object)("ResourceUtils getResourceURL failed! -> " + resourceName));
        }
        return null;
    }

    public static File getFile(String fileName) {
        File rootFolder;
        URL classRootURL = DWResourceUtils.getClassRootPath(DWResourceUtils.class);
        try {
            rootFolder = new File(classRootURL.toURI());
        }
        catch (URISyntaxException e) {
            _log.error((Object)"get file error!", (Throwable)e);
            return null;
        }
        File parentFolder = rootFolder.getParentFile();
        return DWResourceUtils.getFileInFolder(parentFolder, fileName);
    }

    private static File getFileInFolder(File folder, String fileName) {
        File[] files;
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        for (File file : files = folder.listFiles()) {
            if (!file.isFile() || !file.getName().toLowerCase().equals(fileName.toLowerCase())) continue;
            return file;
        }
        return null;
    }

    public static URL getClassRootPath() {
        return DWResourceUtils.getClassRootPath(DWResourceUtils.class);
    }

    public static URL getClassRootPath(Class<?> targetClass) {
        ClassLoader classLoader = targetClass.getClassLoader();
        URL url = classLoader.getResource("");
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource("");
        }
        return url;
    }

    public static File getClassRootPathParentFolder() {
        URL url = DWResourceUtils.getClassRootPath(DWResourceUtils.class);
        File rootFolder = null;
        try {
            rootFolder = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            _log.error((Object)"url.toURI() failed!", (Throwable)e);
        }
        File parentFolder = rootFolder.getParentFile();
        return parentFolder;
    }

    public static String getFolderHeaderPath() {
        return FOLDER_HEADER_PATH;
    }

    public static String getFolderServicePath() {
        return FOLDER_SERVICE_PATH;
    }

    public static String getFolderIndsutryPath() {
        return FOLDER_INDUSTY_PATH;
    }

    public static String getFolderCustomizationPath() {
        return FOLDER_CUSTOMIZATION_PATH;
    }

    static {
        _log = LogFactory.getLog(DWResourceUtils.class);
        String classRootPathParentPath = DWResourceUtils.getClassRootPathParentFolder().getPath();
        FOLDER_HEADER_PATH = classRootPathParentPath + File.separator + INTERFACE;
        FOLDER_SERVICE_PATH = classRootPathParentPath + File.separator + IMPLEMENTATION;
        FOLDER_PROPERTIES_PATH = classRootPathParentPath + File.separator + "properties";
        FOLDER_CUSTOMIZATION_PATH = classRootPathParentPath + File.separator + CUSTOMIZATION;
        FOLDER_INDUSTY_PATH = classRootPathParentPath + File.separator + INDUSTRY;
    }
}

