/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class TokenUtil {
    private static final String PUBLIC_KEY_STRING = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoIyjD5Zs0IZkcl8SjPF8z9p1L88XEQZBImNIoUgS+4mkYev2Ae45XiGAqrGghHGrOpCMA07a4ir4zHaXzoG9hQXLN2vQEsOdtmH5pV/MDYDhui8ksrQncRVBSSsACqqwBJCyC2k6Lj8U92D8NXd+qLBuHeU1oNYsTICU1hxJm6zvZ83HCdH47kRfBziELO50kivm0nCEMA++EBxqLozcQn540yA9a4tQ3kCrE03thNMfo3VM2TZDHU30DnC0x74F5nizkoW2XTEidGLWw47K0VSfYMlukvhYBc1GbtkPtzv+hbcSkhH6o6M1aK6TZEt5Xp0E1e8WoySCRFBULTVWpQIDAQAB";
    private static final String SECRET_KEY = "90<OPfdDS95342ugy1u5&*Y#)*JF(*#QLKFAMEDhg.OA4fdoi5FDS(3ug*s34096";

    public static String get() throws Exception {
        PublicKey publicKey = TokenUtil.getPublicKeyFromString(PUBLIC_KEY_STRING);
        byte[] tokenBytes = TokenUtil.encrypt(SECRET_KEY.getBytes(), publicKey);
        String token = Base64.getEncoder().encodeToString(tokenBytes);
        return token;
    }

    public static boolean verify(String privateKeyString, String token) {
        try {
            PrivateKey privateKey = TokenUtil.getPrivateKeyFromString(privateKeyString);
            byte[] base64TokenBytes = token.getBytes();
            byte[] tokenBytes = Base64.getDecoder().decode(base64TokenBytes);
            byte[] secretKeyBytes = TokenUtil.decrypt(tokenBytes, privateKey);
            String secretKey = new String(secretKeyBytes);
            return SECRET_KEY.equals(secretKey);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private static PublicKey getPublicKeyFromString(String publicKeyString) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(publicKeyString);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(spec);
    }

    private static PrivateKey getPrivateKeyFromString(String privateKeyString) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(privateKeyString);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(spec);
    }

    private static byte[] encrypt(byte[] data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    private static byte[] decrypt(byte[] encryptedData, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(encryptedData);
    }
}

