/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue;

import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.enums.KeyStoreEnum;
import com.digiwin.processor.http.model.KeyStoreRequestBody;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.TokenUtil;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.google.gson.Gson;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public abstract class Client {
    private static final Log log = LogFactory.getLog(Client.class);
    protected static final int DEFAULT_AMQP_PORT = 5672;
    protected static final int DEFAULT_PROTOCOL_PORT = 15672;
    protected static final int DEFAULT_RETRY_TIMES = 3;
    protected static final long DEFAULT_RETRY_INTERVAL = 5000L;
    protected static final String URL_REGEX = "https?:.+";
    protected static final String PROCESSOR_PORT = "8080";
    protected static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");
    protected String mqHost;
    protected Integer amqpPort;
    protected Integer amqpSslPort;
    protected String mqUserName;
    protected String mqPassword;
    protected boolean useSsl = false;
    protected static String processorUrl;
    protected static final String VHOST_NAMESPACE = "_vhost";
    public int retryTimes;
    public long retryInterval;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> heartbeatHandle = null;
    private final Map<String, ConnectionFactory> CONNECTION_FACTORY_MAP = new ConcurrentHashMap<String, ConnectionFactory>();

    protected abstract void doHeartbeat();

    public abstract void close();

    public String getMqHost() {
        return this.mqHost;
    }

    public String getMqUserName() {
        return this.mqUserName;
    }

    public String getMqPassword() {
        return this.mqPassword;
    }

    protected void setProp(String mqHost, Integer amqpPort, Integer amqpSslPort, String mqUserName, String mqPassword) {
        this.mqHost = mqHost;
        this.amqpPort = amqpPort;
        this.amqpSslPort = amqpSslPort;
        this.mqUserName = mqUserName;
        this.mqPassword = mqPassword;
    }

    public void openSSL() {
        this.useSsl = true;
    }

    public void openSSL(KeyStoreEnum keyStore) {
        this.useSsl = true;
    }

    protected Connection getConnection(String vhost) throws Exception {
        ConnectionFactory tFactory = this.CONNECTION_FACTORY_MAP.get(vhost);
        if (tFactory == null) {
            tFactory = new ConnectionFactory();
            tFactory.setHost(this.mqHost);
            Integer tPort = null;
            tPort = this.useSsl ? this.amqpSslPort : this.amqpPort;
            if (tPort != null) {
                tFactory.setPort(tPort.intValue());
            }
            tFactory.setVirtualHost(vhost);
            tFactory.setUsername(this.mqUserName);
            tFactory.setPassword(this.mqPassword);
            tFactory.setAutomaticRecoveryEnabled(false);
            tFactory.setTopologyRecoveryEnabled(false);
            if (this.useSsl) {
                ByteArrayInputStream keyStoreStream = null;
                char[] tPwd = "28682266".toCharArray();
                String token = TokenUtil.get();
                KeyStoreRequestBody keyStoreRequestBody = new KeyStoreRequestBody();
                keyStoreRequestBody.setToken(token);
                String tURL = processorUrl + "api/keystore";
                String tJson = new Gson().toJson((Object)keyStoreRequestBody);
                int count = 0;
                log.info((Object)"Connection to MQ Processor get key store");
                while (true) {
                    try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest(tURL, HttpMethod.POST, tJson);){
                        if (tResponse.getStatusLine().getStatusCode() != 200) {
                            throw new ProcessorContenctFailException(tResponse.toString());
                        }
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)tResponse.getEntity());
                        keyStoreStream = new ByteArrayInputStream(bytes);
                    }
                    catch (Exception e) {
                        if (++count == this.retryTimes) {
                            throw new ProcessorContenctFailException("Connect to MQ processor get key store failed:" + tURL, e);
                        }
                        log.warn((Object)("Connect to MQ processor get key store failed:" + tURL + ",retry"));
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
                try {
                    KeyStore jks = KeyStore.getInstance("JKS");
                    jks.load(keyStoreStream, tPwd);
                    TrustManagerFactory keyStoreManager = TrustManagerFactory.getInstance("SunX509");
                    keyStoreManager.init(jks);
                    SSLContext context = SSLContext.getInstance("TLSv1.2");
                    context.init(null, keyStoreManager.getTrustManagers(), null);
                    tFactory.useSslProtocol(context);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new MqConnectFailException(String.format("SSL error occurred: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()), e);
                }
            }
            this.CONNECTION_FACTORY_MAP.put(vhost, tFactory);
        }
        Connection tConnection = null;
        int tCount = 0;
        while (true) {
            try {
                tConnection = tFactory.newConnection();
                log.info((Object)String.format("Successful connection to MQ server: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()));
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                if (++tCount == this.retryTimes) {
                    throw new MqConnectFailException(String.format("Unable to connect to MQ server: %s:%s,vhost: %s", tFactory.getHost(), tFactory.getPort(), tFactory.getVirtualHost()) + ", " + e.getMessage(), e);
                }
                log.warn((Object)("Connect to MQ server failed, retry after " + this.retryInterval + " millisecond."));
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e1.getMessage(), (Throwable)e1);
                }
                continue;
            }
            break;
        }
        return tConnection;
    }

    public void enableHeartbeat() {
        try {
            if (this.heartbeatHandle == null || this.heartbeatHandle.isCancelled()) {
                this.heartbeatHandle = this.scheduler.scheduleAtFixedRate(() -> this.doHeartbeat(), 0L, 10L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void disableHeartbeat() {
        try {
            if (this.heartbeatHandle != null && !this.heartbeatHandle.isCancelled()) {
                this.heartbeatHandle.cancel(true);
                this.heartbeatHandle = null;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void setProcessorUrl(String processorHost) {
        log.info((Object)("MQ Processor host = " + processorHost));
        if (processorHost.matches(URL_REGEX)) {
            processorUrl = processorHost.endsWith("/") ? processorHost : processorHost + "/";
        } else {
            if (Client.isIpPattern(processorHost)) {
                processorHost = processorHost + ":8080";
            }
            processorUrl = "http://" + processorHost + "/";
        }
    }

    private static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }
}

