/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue;

import com.digiwin.processor.enums.HttpMethod;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);
    private static CloseableHttpClient httpClient;
    private static int timeout;
    private static RequestConfig requestConfig;

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, null, null, null, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, Map<String, String> pHeaders) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, pHeaders, null, null, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, String pContent) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, null, pContent, null, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, Map<String, String> pHeaders, String pContent) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, pHeaders, pContent, null, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, UsernamePasswordCredentials pCredentials) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, null, null, pCredentials, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, Map<String, String> pHeaders, UsernamePasswordCredentials pCredentials) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, pHeaders, null, pCredentials, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, String pContent, UsernamePasswordCredentials pCredentials) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, null, pContent, pCredentials, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, Map<String, String> pHeaders, String pContent, UsernamePasswordCredentials pCredentials) throws IOException {
        return HttpUtil.executHttpRequest(pUrl, pHttpMethod, pHeaders, pContent, pCredentials, 3);
    }

    public static CloseableHttpResponse executHttpRequest(String pUrl, HttpMethod pHttpMethod, Map<String, String> pHeaders, String pContent, UsernamePasswordCredentials pCredentials, Integer pRedirectTimes) throws IOException {
        HttpClientContext tContext = HttpClientContext.create();
        if (pCredentials != null) {
            BasicCredentialsProvider tProvider = new BasicCredentialsProvider();
            tProvider.setCredentials(AuthScope.ANY, (Credentials)pCredentials);
            tContext.setCredentialsProvider((CredentialsProvider)tProvider);
        }
        HttpGet tHttpRequest = null;
        switch (pHttpMethod) {
            case GET: {
                HttpGet tHttpGet = new HttpGet(pUrl);
                tHttpRequest = tHttpGet;
                break;
            }
            case POST: {
                HttpPost httpPost = new HttpPost(pUrl);
                httpPost.setEntity((HttpEntity)new StringEntity(Objects.toString(pContent, ""), ContentType.APPLICATION_JSON));
                tHttpRequest = httpPost;
                break;
            }
            case PUT: {
                HttpPut tHttpPut = new HttpPut(pUrl);
                tHttpPut.setEntity((HttpEntity)new StringEntity(Objects.toString(pContent, ""), ContentType.APPLICATION_JSON));
                tHttpRequest = tHttpPut;
                break;
            }
            case DELETE: {
                HttpDelete tHttpDelete = new HttpDelete(pUrl);
                tHttpRequest = tHttpDelete;
            }
        }
        tHttpRequest.setConfig(requestConfig);
        if (pHeaders != null) {
            for (Map.Entry entry : pHeaders.entrySet()) {
                tHttpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        CloseableHttpResponse tResponse = null;
        try {
            tResponse = httpClient.execute((HttpUriRequest)tHttpRequest, (HttpContext)tContext);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        switch (tResponse.getStatusLine().getStatusCode()) {
            case 301: 
            case 302: 
            case 307: 
            case 308: {
                Integer n = pRedirectTimes;
                Integer n2 = pRedirectTimes = Integer.valueOf(pRedirectTimes - 1);
                if (pRedirectTimes == 0) {
                    return tResponse;
                }
                String string = tResponse.getFirstHeader("location").getValue();
                log.info((Object)("Http request: " + pUrl + " return [" + tResponse.getStatusLine() + "] redirect to " + string));
                tResponse.close();
                return HttpUtil.executHttpRequest(string, pHttpMethod, pHeaders, pContent, pCredentials, pRedirectTimes);
            }
        }
        return tResponse;
    }

    static {
        timeout = 30;
        Registry tRegistry = null;
        try {
            SSLConnectionSocketFactory tSSLConnectionSocketFactory = null;
            tSSLConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().build(), new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            tRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)tSSLConnectionSocketFactory).build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Map<String, String> env = System.getenv();
        boolean isSSLConnectionSocketFactory = Boolean.valueOf(env.getOrDefault("isSSLConnectionSocketFactory", "false"));
        PoolingHttpClientConnectionManager tConnectionManager = null;
        if (tRegistry != null) {
            if (isSSLConnectionSocketFactory) {
                tConnectionManager = new PoolingHttpClientConnectionManager(tRegistry);
                log.info((Object)"isSSLConnectionSocketFactory: true");
            } else {
                tConnectionManager = new PoolingHttpClientConnectionManager();
                log.info((Object)"isSSLConnectionSocketFactory: false");
            }
        } else {
            tConnectionManager = new PoolingHttpClientConnectionManager();
            log.info((Object)"isSSLConnectionSocketFactory: false");
        }
        tConnectionManager.setMaxTotal(100);
        tConnectionManager.setDefaultMaxPerRoute(20);
        HttpClientBuilder tClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)tConnectionManager);
        httpClient = tClientBuilder.build();
        String tTimeout = System.getenv("HTTP_TIMEOUT");
        if (tTimeout != null) {
            timeout = Integer.valueOf(tTimeout);
        }
        int tTimeoutSec = Long.valueOf(TimeUnit.SECONDS.toMillis(timeout)).intValue();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectionRequestTimeout(tTimeoutSec);
        requestConfigBuilder.setConnectTimeout(tTimeoutSec);
        requestConfigBuilder.setSocketTimeout(tTimeoutSec);
        requestConfig = requestConfigBuilder.build();
    }
}

