/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.saas;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.http.model.SaasConnectionRequestBody;
import com.digiwin.processor.http.model.SaasConnectionResponseBody;
import com.digiwin.processor.http.model.SaasInfoRequestBody;
import com.digiwin.processor.model.MqInfo;
import com.digiwin.processor.polling.CircuitBreaker;
import com.digiwin.queue.Base64;
import com.digiwin.queue.Client;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.RsaUtil;
import com.digiwin.queue.TokenUtil;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.digiwin.queue.exceptions.TokenVerificationFailedException;
import com.digiwin.queue.saas.PrivateKeyUtil;
import com.digiwin.queue.saas.QueryRegisterEnum;
import com.digiwin.queue.saas.SaasClientImpl;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public abstract class SaasClient
extends Client {
    private static final Log log = LogFactory.getLog(SaasClient.class);
    protected static final String QUEUE_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s\\.queue";
    protected static final String CONSUMER_TAG_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s";
    protected static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");
    protected static final String END = "DWQueue-saas";
    protected static final Gson GSON = new Gson();
    protected String mqpHost;
    protected URL url;
    protected Connection saasConnection;
    protected Map<String, Connection> tenantConnectionMap = new HashMap<String, Connection>();
    protected static boolean standby = false;
    protected static CircuitBreaker saasCircuitBreaker = CircuitBreaker.CLOSED;
    protected static ExecutorService circuitBreakerPollingExecutorService = Executors.newSingleThreadExecutor();
    protected ExecutorService messagePollingExecutorService = Executors.newSingleThreadExecutor();
    protected static Boolean quorum = null;
    protected String tenantId;
    protected String gatewayId;
    protected String gatewayName;
    protected String apName;
    protected DWQueueReceiver receiver;

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword, false);
    }

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword, boolean standby) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword, standby);
    }

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword, Integer retryTimes, Long retryInterval) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword, retryTimes, retryInterval, false);
    }

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword, Integer retryTimes, Long retryInterval, boolean standby) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword, retryTimes, retryInterval, standby);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword) {
        return SaasClient.init(protocol, processorHost, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, 3, 5000L, false);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, boolean standby) {
        return SaasClient.init(protocol, processorHost, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, 3, 5000L, standby);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, int retryTimes, long retryInterval) {
        return SaasClient.init(protocol, processorHost, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, retryTimes, retryInterval, false);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, int retryTimes, long retryInterval, boolean standby) {
        try {
            SaasClientImpl instance = new SaasClientImpl();
            instance.retryTimes = retryTimes;
            instance.retryInterval = retryInterval;
            SaasClient.setProcessorUrl((String)processorHost);
            if (protocol == null) {
                protocol = Protocol.HTTP;
            }
            instance.url = protocolPort != null ? (SaasClient.isIpPattern(mqHost) ? new URL(protocol.toString(), mqHost, protocolPort, "/api") : new URL(protocol.toString(), mqHost, "/api")) : new URL(protocol.toString(), mqHost, "/api");
            AbstractMap.SimpleEntry<String, String> saasInfo = SaasClient.getSaasInfo(retryTimes, retryInterval);
            String username = saasInfo.getKey();
            String password = saasInfo.getValue();
            instance.setProp(mqHost, amqpPort, amqpPort, username, password);
            SaasClient.setStandby(standby);
            SaasClient.saasCircuitBreakerPolling();
            String tURL = processorUrl + "api/quorum";
            int count = 0;
            while (true) {
                try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.GET);){
                    log.info((Object)("MQ Processor response(quorum): " + tResponse));
                    if (tResponse.getStatusLine().getStatusCode() != 200) {
                        throw new ProcessorContenctFailException(tResponse.toString());
                    }
                    String tquorumResponseStr = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                    Gson gson = new Gson();
                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                    Map quorumMap = (Map)gson.fromJson(tquorumResponseStr, type);
                    String quorumStr = (String)quorumMap.get("quorum");
                    quorum = Boolean.valueOf(quorumStr);
                }
                catch (Exception e) {
                    if (++count == retryTimes) {
                        throw new ProcessorContenctFailException("Connect to MQ processor failed(quorum):" + tURL, e);
                    }
                    log.warn((Object)("Connect to MQ processor failed(quorum):" + tURL + ",retry"));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static void setStandby(boolean standby) {
        SaasClient.standby = standby;
    }

    protected static void saasCircuitBreakerPolling() {
        if (!standby) {
            return;
        }
        Runnable circuitBreakerPollingTask = new Runnable(){

            @Override
            public void run() {
                block13: while (true) {
                    try {
                        while (true) {
                            String token = TokenUtil.get();
                            String encodeToken = URLEncoder.encode(token, StandardCharsets.UTF_8.toString());
                            String url = processorUrl + "api/polling/circuitbreaker?status=" + saasCircuitBreaker.value() + "&token=" + encodeToken;
                            RequestConfig defaultRequestConfig = RequestConfig.custom().build();
                            try {
                                CloseableHttpResponse response = HttpUtil.executHttpRequest((RequestConfig)defaultRequestConfig, (String)url, (HttpMethod)HttpMethod.GET);
                                Throwable throwable = null;
                                try {
                                    int statusCode = response.getStatusLine().getStatusCode();
                                    if (statusCode == 204) continue block13;
                                    if (statusCode == 200) {
                                        Type type;
                                        Gson gson = new Gson();
                                        HttpEntity httpEntity = response.getEntity();
                                        String responseString = EntityUtils.toString((HttpEntity)httpEntity);
                                        Map map = (Map)gson.fromJson(responseString, type = new TypeToken<Map<String, String>>(){}.getType());
                                        String circuitBreakerString = (String)map.get("circuitBreaker");
                                        CircuitBreaker circuitBreaker = CircuitBreaker.fromString((String)circuitBreakerString);
                                        if (saasCircuitBreaker.equals((Object)circuitBreaker)) continue block13;
                                        log.warn((Object)("[circuitBreakerPolling] " + saasCircuitBreaker + " -> " + circuitBreaker));
                                        saasCircuitBreaker = circuitBreaker;
                                        continue block13;
                                    }
                                    log.warn((Object)("[circuitBreakerPolling] Unexpected status code: " + statusCode));
                                    continue block13;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (response == null) continue block13;
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue block13;
                                    }
                                    response.close();
                                    continue block13;
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)("[circuitBreakerPolling] message: " + e.getMessage()), (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("[circuitBreakerPolling] message: " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        if (circuitBreakerPollingExecutorService == null) {
            circuitBreakerPollingExecutorService = Executors.newSingleThreadExecutor();
        }
        circuitBreakerPollingExecutorService.execute(circuitBreakerPollingTask);
    }

    protected void messagePolling() {
        if (!standby) {
            return;
        }
        Runnable messagePollingTask = new Runnable(){

            @Override
            public void run() {
                while (!CircuitBreaker.CLOSED.equals((Object)saasCircuitBreaker)) {
                    try {
                        String token = TokenUtil.get();
                        String encodeToken = URLEncoder.encode(token, StandardCharsets.UTF_8.toString());
                        RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(SaasClient.this.tenantId, SaasClient.this.gatewayId, SaasClient.this.gatewayName, SaasClient.this.apName);
                        String publishKey = topicSupporter.getPublishKey();
                        String messagePollingUrl = processorUrl + "api/polling/message?publishKey=" + publishKey + "&token=" + encodeToken + "&tenantId=" + SaasClient.this.tenantId;
                        RequestConfig defaultRequestConfig = RequestConfig.custom().build();
                        try {
                            CloseableHttpResponse messagePollingResponse = HttpUtil.executHttpRequest((RequestConfig)defaultRequestConfig, (String)messagePollingUrl, (HttpMethod)HttpMethod.GET);
                            Throwable throwable = null;
                            try {
                                int statusCode = messagePollingResponse.getStatusLine().getStatusCode();
                                Gson gson = new Gson();
                                if (statusCode == 204) continue;
                                if (statusCode == 200) {
                                    HttpEntity httpEntity = messagePollingResponse.getEntity();
                                    String messageString = EntityUtils.toString((HttpEntity)httpEntity);
                                    Type type = new TypeToken<Map<String, String>>(){}.getType();
                                    Map messageMap = (Map)gson.fromJson(messageString, type);
                                    String uuid = (String)messageMap.get("uuid");
                                    final String message = (String)messageMap.get("message");
                                    ExecutorService messagePollingExecutorService = Executors.newSingleThreadExecutor();
                                    Callable<String> task = new Callable<String>(){

                                        @Override
                                        public String call() throws Exception {
                                            String result = SaasClient.this.receiver.execute(message);
                                            result = Objects.toString(result, "");
                                            return result;
                                        }
                                    };
                                    Future<String> future = messagePollingExecutorService.submit(task);
                                    messagePollingExecutorService.shutdown();
                                    String result = future.get();
                                    String responseUrl = processorUrl + "api/standby/response";
                                    String responseToken = TokenUtil.get();
                                    HashMap<String, String> response = new HashMap<String, String>();
                                    response.put("tenantId", SaasClient.this.tenantId);
                                    response.put("uuid", uuid);
                                    response.put("response", result);
                                    response.put("token", responseToken);
                                    String responseString = gson.toJson(response);
                                    HttpUtil.executHttpRequest((String)responseUrl, (HttpMethod)HttpMethod.POST, (String)responseString);
                                    continue;
                                }
                                log.info((Object)("[messagePolling] Unexpected status code: " + statusCode));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (messagePollingResponse == null) continue;
                                if (throwable != null) {
                                    try {
                                        messagePollingResponse.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                messagePollingResponse.close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("[messagePolling] message: " + e.getMessage()), (Throwable)e);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("[messagePolling] message: " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    break;
                }
                return;
            }
        };
        if (this.messagePollingExecutorService == null) {
            this.messagePollingExecutorService = Executors.newSingleThreadExecutor();
        }
        this.messagePollingExecutorService.execute(messagePollingTask);
    }

    public static SaasClient init(String mqpHost, String token) throws ProcessorContenctFailException, TokenVerificationFailedException {
        return SaasClient.init(mqpHost, token, 3, 5000L, false);
    }

    public static SaasClient init(String mqpHost, String token, boolean standby) throws ProcessorContenctFailException, TokenVerificationFailedException {
        return SaasClient.init(mqpHost, token, 3, 5000L, standby);
    }

    public static SaasClient init(String mqpHost, String token, int retryTimes, long retryInterval) throws ProcessorContenctFailException, TokenVerificationFailedException {
        return SaasClient.init(mqpHost, token, retryTimes, retryInterval, false);
    }

    public static SaasClient init(String mqpHost, String token, int retryTimes, long retryInterval, boolean standby) throws ProcessorContenctFailException, TokenVerificationFailedException {
        SaasClientImpl instance;
        block17: {
            instance = new SaasClientImpl();
            instance.mqpHost = mqpHost;
            String tProcessorHost = instance.mqpHost;
            if (SaasClient.isIpPattern(tProcessorHost)) {
                tProcessorHost = tProcessorHost + ":8080";
            }
            SaasClient.setProcessorUrl((String)mqpHost);
            String tURL = "http://" + tProcessorHost + "/api/saasConnecation";
            SaasConnectionRequestBody tRequestBody = new SaasConnectionRequestBody();
            tRequestBody.setToken(token);
            try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)GSON.toJson((Object)tRequestBody));){
                if (tResponse.getStatusLine().getStatusCode() != 200) {
                    throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL + ":" + tResponse.toString());
                }
                String tResponseBody = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                SaasConnectionResponseBody tSaasConnectionResponseBody = (SaasConnectionResponseBody)GSON.fromJson(tResponseBody, SaasConnectionResponseBody.class);
                if (tSaasConnectionResponseBody.getSuccess().booleanValue()) {
                    AbstractMap.SimpleEntry<String, String> saasInfo = SaasClient.getSaasInfo(retryTimes, retryInterval);
                    String username = saasInfo.getKey();
                    String password = saasInfo.getValue();
                    MqInfo tMqInfo = tSaasConnectionResponseBody.getMqInfo();
                    instance.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), username, new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)password)));
                    break block17;
                }
                throw new TokenVerificationFailedException(tSaasConnectionResponseBody.getMessage());
            }
            catch (Exception e) {
                throw new ProcessorContenctFailException(e.getMessage(), e);
            }
        }
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        SaasClient.setStandby(standby);
        SaasClient.saasCircuitBreakerPolling();
        return instance;
    }

    @Deprecated
    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3, boolean var4) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String queryRegister(String var1, String var2, com.digiwin.processor.enums.QueryRegisterEnum var3, boolean var4) throws ProcessorContenctFailException, MqConnectFailException;

    @Deprecated
    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String queryRegister(String var1, String var2, com.digiwin.processor.enums.QueryRegisterEnum var3) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String onSyncSend(String var1, String var2, String var3, boolean var4) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3, Integer var4, TimeUnit var5, boolean var6) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3, Integer var4, TimeUnit var5) throws Exception;

    public abstract void onSend(String var1, String var2, String var3) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, TimeoutCallback var4, Integer var5, TimeUnit var6) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4, TimeoutCallback var5, Integer var6, TimeUnit var7) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2, String var3) throws Exception;

    public abstract void registerSaas(String var1, String var2, String var3, String var4, DWQueueReceiver var5) throws Exception;

    public void close() {
        this.disableHeartbeat();
        if (this.saasConnection != null) {
            try {
                this.saasConnection.abort();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (Connection tConnection : this.tenantConnectionMap.values()) {
            try {
                tConnection.abort();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessage(Connection connection, String exchangeName, String routingKey, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(exchangeName, routingKey, props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == this.retryTimes) {
                    throw e;
                }
                log.warn((Object)"Publish message failed,retry");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.abort();
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    protected static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AbstractMap.SimpleEntry<String, String> getSaasInfo(int retryTimes, long retryInterval) throws Exception {
        String token = TokenUtil.get();
        SaasInfoRequestBody saasInfoRequestBody = new SaasInfoRequestBody();
        saasInfoRequestBody.setToken(token);
        String tURL = processorUrl + "api/saasinfo";
        String tJson = new Gson().toJson((Object)saasInfoRequestBody);
        int count = 0;
        log.info((Object)"Connection to MQ Processor get saas info");
        while (true) {
            try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)tJson);){
                AbstractMap.SimpleEntry<String, String> entry;
                if (tResponse.getStatusLine().getStatusCode() != 200) {
                    throw new ProcessorContenctFailException(tResponse.toString());
                }
                String tResFromMqp = EntityUtils.toString((HttpEntity)tResponse.getEntity());
                JsonObject tJsonObject = new JsonParser().parse(tResFromMqp).getAsJsonObject();
                String username = tJsonObject.get("username").getAsString();
                String password = tJsonObject.get("password").getAsString();
                String saasInfoPrivateKey = PrivateKeyUtil.getSaasInfoPrivateKey();
                byte[] base64PasswordBytes = password.getBytes();
                byte[] passwordBytes = Base64.getDecoder().decode(base64PasswordBytes);
                byte[] secretKeyBytes = RsaUtil.decrypt((byte[])passwordBytes, (String)saasInfoPrivateKey);
                password = new String(secretKeyBytes);
                AbstractMap.SimpleEntry<String, String> simpleEntry = entry = new AbstractMap.SimpleEntry<String, String>(username, password);
                return simpleEntry;
            }
            catch (Exception e) {
                if (++count == retryTimes) {
                    throw new ProcessorContenctFailException("Connect to MQ processor get saas info failed:" + tURL, e);
                }
                log.warn((Object)("Connect to MQ processor get saas info failed:" + tURL + ",retry"));
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    public static interface TimeoutCallback {
        public void onCallback(String var1);
    }

    public static interface CompleteCallback {
        public void onCallback(String var1);
    }

    public static enum Protocol {
        HTTP,
        HTTPS;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

