/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.saas;

import com.digiwin.queue.Client;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.saas.QueryRegisterEnum;
import com.digiwin.queue.saas.model.ConsumerInfo;
import com.digiwin.queue.saas.model.QueueInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public abstract class SaasClient
extends Client {
    private static final Log log = LogFactory.getLog(SaasClient.class);
    private static final String queueRegex = "%s\\.\\w+\\.[^\\.]+\\.%s\\.queue";
    private static final String consumerTagRegex = "%s\\.\\w+\\.[^\\.]+\\.%s";
    protected static HttpClient httpClient;
    protected static URL url;
    protected Connection saasConnection;
    protected static Map<String, Connection> tenantConnectionMap;
    private static SaasClient instance;

    static {
        tenantConnectionMap = new HashMap<String, Connection>();
    }

    public static SaasClient init(String mqHost, String mqUserName, String mqPassword) {
        return SaasClient.init(null, mqHost, null, null, mqUserName, mqPassword);
    }

    public static SaasClient init(String mqHost, String mqUserName, String mqPassword, Integer retryTimes, Long retryInterval) {
        return SaasClient.init(null, mqHost, null, null, mqUserName, mqPassword, retryTimes, retryInterval);
    }

    public static SaasClient init(Protocol protocol, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword) {
        return SaasClient.init(protocol, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, 3, 5000L);
    }

    public static SaasClient init(Protocol protocol, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, int retryTimes, long retryInterval) {
        if (instance == null) {
            instance = new SaasClientImple();
        } else {
            log.warn((Object)"Already initialized,reset");
            instance.close();
            instance = new SaasClientImple();
        }
        SaasClient.setProp((String)mqHost, (Integer)amqpPort, (String)mqUserName, (String)mqPassword);
        SaasClient.retryTimes = retryTimes;
        SaasClient.retryInterval = retryInterval;
        if (protocol == null) {
            protocol = Protocol.HTTP;
        }
        try {
            url = protocolPort != null ? new URL(protocol.toString(), mqHost, protocolPort, "/api") : new URL(protocol.toString(), mqHost, "/api");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        UsernamePasswordCredentials tCredentials = new UsernamePasswordCredentials(SaasClient.mqUserName, SaasClient.mqPassword);
        BasicCredentialsProvider tProvider = new BasicCredentialsProvider();
        tProvider.setCredentials(AuthScope.ANY, (Credentials)tCredentials);
        httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)tProvider).build();
        return instance;
    }

    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3) throws MqConnectFailException;

    public abstract void onSend(String var1, String var2, String var3) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, TimeoutCallback var4, Integer var5, TimeUnit var6) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4, TimeoutCallback var5, Integer var6, TimeUnit var7) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2, String var3) throws Exception;

    public void close() {
        if (this.saasConnection != null) {
            try {
                this.saasConnection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Connection tConnection : tenantConnectionMap.values()) {
            try {
                tConnection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected HttpResponse executHttpRequest(String pUrl) throws IOException {
        HttpGet tHttpGet = new HttpGet(pUrl);
        int count = 0;
        while (true) {
            try {
                HttpResponse tResponse = httpClient.execute((HttpUriRequest)tHttpGet);
                return tResponse;
            }
            catch (Exception e) {
                if (++count == 3) {
                    throw e;
                }
                log.warn((Object)String.format("Connect to URL: %s failed,retry.", pUrl));
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }

    protected void publishMessage(Connection connection, RabbitmqTopicSupporter topicSupporter, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(topicSupporter.getExchangeName(), topicSupporter.getPublishKey(), props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == retryTimes) {
                    throw e;
                }
                log.warn((Object)"Publish message failed,retry");
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.close();
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    public static interface CompleteCallback {
        public void onCallback(String var1);
    }

    public static enum Protocol {
        HTTP,
        HTTPS;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    private static class SaasClientImple
    extends SaasClient {
        private ExecutorService executorService = Executors.newCachedThreadPool();

        private SaasClientImple() {
        }

        @Override
        public String queryRegister(String tenantId, String apName, QueryRegisterEnum queryRegisterEnum) throws MqConnectFailException {
            if (tenantId == null && apName == null) {
                JsonObject tJsonObject = new JsonObject();
                tJsonObject.addProperty("message", "at least one of tenantId or apName needs to be set");
                return tJsonObject.toString();
            }
            Gson tGson = new Gson();
            JsonArray tAlives = new JsonArray();
            String tHostName = tenantId == null ? "" : String.valueOf(tenantId) + "_vhost";
            HttpResponse tHttpResponse = null;
            switch (queryRegisterEnum) {
                case QUERY_REGISTER: {
                    try {
                        tHttpResponse = this.executHttpRequest(String.valueOf(url.toURI().toString()) + "/queues/" + tHostName);
                    }
                    catch (Exception e) {
                        throw new MqConnectFailException("Connect to MQ server failed", e);
                    }
                    try {
                        if (tHttpResponse.getStatusLine().getStatusCode() == 200) {
                            String tResponse = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity(), (Charset)Charsets.UTF_8);
                            Type tType = new TypeToken<ArrayList<QueueInfo>>(){}.getType();
                            List tQueueInfos = (List)tGson.fromJson(tResponse, tType);
                            for (QueueInfo tQueueInfo : tQueueInfos) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = tenantId == null ? "\\w+" : tenantId;
                                Object object = objectArray[1] = apName == null ? "\\w+" : apName;
                                if (!tQueueInfo.getName().matches(String.format(SaasClient.queueRegex, objectArray))) continue;
                                String[] tQueueInfoParts = tQueueInfo.getName().split("\\.");
                                JsonObject tAlive = new JsonObject();
                                tAlive.addProperty("tenantId", tQueueInfoParts[0]);
                                tAlive.addProperty("gatewayId", tQueueInfoParts[1]);
                                tAlive.addProperty("gatewayName", tQueueInfoParts[2]);
                                tAlive.addProperty("apName", tQueueInfoParts[3]);
                                tAlive.addProperty("isOnline", Boolean.valueOf(tQueueInfo.getConsumers() > 0));
                                tAlives.add((JsonElement)tAlive);
                            }
                            break;
                        }
                        String tErrorMessage = "";
                        if (tHttpResponse.getEntity() != null) {
                            tErrorMessage = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
                        }
                        JsonObject tJsonObject = new JsonObject();
                        tJsonObject.addProperty("status_code", (Number)tHttpResponse.getStatusLine().getStatusCode());
                        JsonElement tJsonElement = new JsonParser().parse(tErrorMessage);
                        tJsonObject.add("message", tJsonElement);
                        tJsonObject.addProperty("message", tErrorMessage);
                        return tJsonObject.toString();
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        JsonObject tJsonObject = new JsonObject();
                        tJsonObject.addProperty("erroe", e.getMessage());
                        return tJsonObject.toString();
                    }
                }
                case QUERY_ONLINE_REGISTER: {
                    try {
                        tHttpResponse = this.executHttpRequest(String.valueOf(url.toURI().toString()) + "/consumers/" + tHostName);
                    }
                    catch (Exception e) {
                        throw new MqConnectFailException("Connect to MQ server failed", e);
                    }
                    try {
                        if (tHttpResponse.getStatusLine().getStatusCode() == 200) {
                            String tResponse = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity(), (Charset)Charsets.UTF_8);
                            Type tType = new TypeToken<ArrayList<ConsumerInfo>>(){}.getType();
                            List tConsumerInfos = (List)tGson.fromJson(tResponse, tType);
                            for (ConsumerInfo tConsumerInfo : tConsumerInfos) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = tenantId == null ? "\\w+" : tenantId;
                                Object object = objectArray[1] = apName == null ? "\\w+" : apName;
                                if (!tConsumerInfo.getConsumerTag().matches(String.format(SaasClient.consumerTagRegex, objectArray))) continue;
                                String[] tConsumerTagParts = tConsumerInfo.getConsumerTag().split("\\.");
                                JsonObject tAlive = new JsonObject();
                                tAlive.addProperty("tenantId", tConsumerTagParts[0]);
                                tAlive.addProperty("gatewayId", tConsumerTagParts[1]);
                                tAlive.addProperty("gatewayName", tConsumerTagParts[2]);
                                tAlive.addProperty("apName", tConsumerTagParts[3]);
                                tAlives.add((JsonElement)tAlive);
                            }
                            break;
                        }
                        String tErrorMessage = "";
                        if (tHttpResponse.getEntity() != null) {
                            tErrorMessage = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
                        }
                        JsonObject tJsonObject = new JsonObject();
                        tJsonObject.addProperty("status_code", (Number)tHttpResponse.getStatusLine().getStatusCode());
                        try {
                            JsonElement tJsonElement = new JsonParser().parse(tErrorMessage);
                            tJsonObject.add("message", tJsonElement);
                        }
                        catch (JsonParseException e) {
                            tJsonObject.addProperty("message", tErrorMessage);
                        }
                        return tJsonObject.toString();
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        JsonObject tJsonObject = new JsonObject();
                        tJsonObject.addProperty("erroe", e.getMessage());
                        return tJsonObject.toString();
                    }
                }
            }
            return tAlives.toString();
        }

        @Override
        public void onSend(String tenantId, String gatewayID, String message) throws Exception {
            this.onSend(tenantId, gatewayID, message, null, null, null, null);
        }

        @Override
        public void onSend(String tenantId, String gatewayID, String message, CompleteCallback completeCallback) throws Exception {
            this.onSend(tenantId, gatewayID, message, completeCallback, null, 2, TimeUnit.HOURS);
        }

        @Override
        public void onSend(String tenantId, String gatewayID, String message, TimeoutCallback timeoutCallback, Integer timeout, TimeUnit timeoutUnit) throws Exception {
            this.onSend(tenantId, gatewayID, message, null, timeoutCallback, timeout, timeoutUnit);
        }

        @Override
        public void onSend(String tenantId, String gatewayID, final String message, final CompleteCallback completeCallback, final TimeoutCallback timeoutCallback, final Integer timeout, final TimeUnit timeoutUnit) throws Exception {
            ExecuteWrapper tWrapper;
            Long tTimeout = null;
            if (timeout != null && timeoutUnit != null) {
                tTimeout = timeoutUnit.toMillis(timeout.intValue());
            }
            if ((tWrapper = this.executeSend(tenantId, gatewayID, message, completeCallback, tTimeout)) != null) {
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                BlockingQueue<Boolean> response = tWrapper.getResponse();
                                Channel channel = tWrapper.getChannel();
                                String consumerTag = tWrapper.getConsumerTag();
                                String topic = tWrapper.getTopic();
                                Boolean result = response.poll(timeout.longValue(), timeoutUnit);
                                channel.basicCancel(consumerTag);
                                if (result == null) {
                                    JsonObject jo = new JsonObject();
                                    jo.addProperty("topic", topic);
                                    jo.addProperty("result", Boolean.valueOf(false));
                                    jo.addProperty("message", message);
                                    jo.add("detail", (JsonElement)new JsonArray());
                                    if (timeoutCallback != null) {
                                        timeoutCallback.onCallback(jo.toString());
                                    } else if (completeCallback != null) {
                                        completeCallback.onCallback(jo.toString());
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                                try {
                                    tWrapper.getChannel().close();
                                }
                                catch (IOException | TimeoutException e2) {
                                    log.error((Object)e2.getMessage(), (Throwable)e2);
                                }
                            }
                        }
                        finally {
                            try {
                                tWrapper.getChannel().close();
                            }
                            catch (IOException | TimeoutException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void onStandardBroadcast(String tenantId, String message) throws Exception {
            this.onStandardBroadcast(tenantId, null, message);
        }

        @Override
        public void onStandardBroadcast(String tenantId, String apName, String message) throws Exception {
            HttpGet tHttpGet = new HttpGet(url.toURI() + "/queues");
            HttpResponse tHttpResponse = httpClient.execute((HttpUriRequest)tHttpGet);
            String tResponse = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity(), (Charset)Charsets.UTF_8);
            Gson tGson = new Gson();
            Type tType = new TypeToken<ArrayList<QueueInfo>>(){}.getType();
            List tQueueInfos = (List)tGson.fromJson(tResponse, tType);
            for (QueueInfo tQueueInfo : tQueueInfos) {
                try {
                    String[] tQueueInfoParts = tQueueInfo.getName().split("\\.");
                    if (!tQueueInfoParts[0].equals(tenantId)) continue;
                    if (apName == null) {
                        this.onSend(tenantId, tQueueInfoParts[1], message);
                        continue;
                    }
                    if (tQueueInfoParts.length <= 4 || !apName.equals(tQueueInfoParts[3])) continue;
                    this.onSend(tenantId, tQueueInfoParts[1], message);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }

        private ExecuteWrapper executeSend(String tenantId, String gatewayId, String message, final CompleteCallback completeCallback, Long timeout) throws Exception {
            Connection tTenantConnection;
            if (this.saasConnection == null || !this.saasConnection.isOpen()) {
                this.saasConnection = this.getConnection("/");
            }
            if ((tTenantConnection = (Connection)tenantConnectionMap.get(tenantId)) == null || !tTenantConnection.isOpen()) {
                tTenantConnection = this.getConnection(String.valueOf(tenantId) + "_vhost");
                tenantConnectionMap.put(tenantId, tTenantConnection);
            }
            RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(tenantId, gatewayId, null, null);
            if (timeout != null) {
                Channel tSaasChannel = this.saasConnection.createChannel();
                final String tCorrelationId = UUID.randomUUID().toString();
                String tReplyQueueName = tSaasChannel.queueDeclare().getQueue();
                AMQP.BasicProperties.Builder tBuilder = new AMQP.BasicProperties.Builder().correlationId(tCorrelationId).replyTo(tReplyQueueName).expiration(timeout.toString());
                AMQP.BasicProperties props = tBuilder.build();
                final ArrayBlockingQueue<Boolean> response = new ArrayBlockingQueue<Boolean>(1);
                String consumerTag = tSaasChannel.basicConsume(tReplyQueueName, true, (Consumer)new DefaultConsumer(tSaasChannel){

                    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                        if (properties != null && properties.getCorrelationId().equals(tCorrelationId)) {
                            String message = new String(body, "UTF-8");
                            if (completeCallback != null) {
                                completeCallback.onCallback(message);
                            }
                            response.offer(true);
                        }
                    }
                });
                this.publishMessage(tTenantConnection, topicSupporter, props, message);
                ExecuteWrapper executeWrapper = new ExecuteWrapper(response, tSaasChannel, consumerTag, topicSupporter.getMainTopic());
                return executeWrapper;
            }
            this.publishMessage(tTenantConnection, topicSupporter, null, message);
            return null;
        }

        private class ExecuteWrapper {
            private BlockingQueue<Boolean> response;
            private Channel channel;
            private String consumerTag;
            private String topic;

            public ExecuteWrapper(BlockingQueue<Boolean> response, Channel channel, String consumerTag, String topic) {
                this.response = response;
                this.channel = channel;
                this.consumerTag = consumerTag;
                this.topic = topic;
            }

            public BlockingQueue<Boolean> getResponse() {
                return this.response;
            }

            public Channel getChannel() {
                return this.channel;
            }

            public String getConsumerTag() {
                return this.consumerTag;
            }

            public String getTopic() {
                return this.topic;
            }
        }
    }

    public static interface TimeoutCallback {
        public void onCallback(String var1);
    }
}

