/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.saas;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.enums.QueryRegisterEnum;
import com.digiwin.processor.http.model.SaasConnectionRequestBody;
import com.digiwin.processor.http.model.SaasConnectionResponseBody;
import com.digiwin.processor.model.MqInfo;
import com.digiwin.queue.Client;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.digiwin.queue.exceptions.TokenVerificationFailedException;
import com.digiwin.queue.saas.SaasClientImpl;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaasClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(SaasClient.class);
    protected static final String QUEUE_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s\\.queue";
    protected static final String CONSUMER_TAG_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s";
    protected static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");
    protected static final Gson GSON = new Gson();
    protected String mqpHost;
    protected URL url;
    protected Connection saasConnection;
    protected Map<String, Connection> tenantConnectionMap = new HashMap<String, Connection>();
    protected String replyName;

    @Deprecated
    public static SaasClient init(String mqHost, String mqUserName, String mqPassword) {
        return SaasClient.init(null, mqHost, null, null, mqUserName, mqPassword);
    }

    @Deprecated
    public static SaasClient init(String mqHost, String mqUserName, String mqPassword, Integer retryTimes, Long retryInterval) {
        return SaasClient.init(null, mqHost, null, null, mqUserName, mqPassword, retryTimes, retryInterval);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword) {
        return SaasClient.init(protocol, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, 3, 5000L);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, int retryTimes, long retryInterval) {
        SaasClientImpl instance = new SaasClientImpl();
        instance.setProp(mqHost, amqpPort, amqpPort, mqUserName, mqPassword);
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        if (protocol == null) {
            protocol = Protocol.HTTP;
        }
        try {
            instance.url = protocolPort != null ? new URL(protocol.toString(), mqHost, protocolPort, "/api") : new URL(protocol.toString(), mqHost, "/api");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        instance.replyName = UUID.randomUUID().toString() + ".reply";
        return instance;
    }

    public static SaasClient init(String mqpHost, String token) throws ProcessorContenctFailException, TokenVerificationFailedException {
        return SaasClient.init(mqpHost, token, 3, 5000L);
    }

    public static SaasClient init(String mqpHost, String token, int retryTimes, long retryInterval) throws ProcessorContenctFailException, TokenVerificationFailedException {
        SaasClientImpl instance;
        block17: {
            instance = new SaasClientImpl();
            instance.mqpHost = mqpHost;
            String tProcessorHost = instance.mqpHost;
            if (SaasClient.isIpPattern(tProcessorHost)) {
                tProcessorHost = tProcessorHost + ":8080";
            }
            String tURL = "http://" + tProcessorHost + "/api/saasConnecation";
            SaasConnectionRequestBody tRequestBody = new SaasConnectionRequestBody();
            tRequestBody.setToken(token);
            try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)GSON.toJson((Object)tRequestBody));){
                if (tResponse.getStatusLine().getStatusCode() != 200) {
                    throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL + ":" + tResponse.toString());
                }
                String tResponseBody = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                SaasConnectionResponseBody tSaasConnectionResponseBody = (SaasConnectionResponseBody)GSON.fromJson(tResponseBody, SaasConnectionResponseBody.class);
                if (tSaasConnectionResponseBody.getSuccess().booleanValue()) {
                    MqInfo tMqInfo = tSaasConnectionResponseBody.getMqInfo();
                    instance.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), tMqInfo.getMqUser(), new String(Base64.decodeBase64((String)tMqInfo.getMqPasswordEncoded())));
                    break block17;
                }
                throw new TokenVerificationFailedException(tSaasConnectionResponseBody.getMessage());
            }
            catch (IOException e) {
                throw new ProcessorContenctFailException(e.getMessage(), (Exception)e);
            }
        }
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        instance.replyName = UUID.randomUUID().toString() + ".reply";
        return instance;
    }

    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract void onSend(String var1, String var2, String var3) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, TimeoutCallback var4, Integer var5, TimeUnit var6) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4, TimeoutCallback var5, Integer var6, TimeUnit var7) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2, String var3) throws Exception;

    public abstract void registerSaas(String var1, String var2, String var3, String var4, DWQueueReceiver var5) throws MqConnectFailException, IOException;

    public void close() {
        this.disableHeartbeat();
        if (this.saasConnection != null) {
            try {
                this.saasConnection.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Connection tConnection : this.tenantConnectionMap.values()) {
            try {
                tConnection.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessage(Connection connection, String exchangeName, String routingKey, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(exchangeName, routingKey, props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == this.retryTimes) {
                    throw e;
                }
                log.warn("Publish message failed,retry");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.close();
                }
                catch (Exception e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    protected static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    public static interface TimeoutCallback {
        public void onCallback(String var1);
    }

    public static interface CompleteCallback {
        public void onCallback(String var1);
    }

    public static enum Protocol {
        HTTP,
        HTTPS;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

