/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.saas;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.http.model.QueryRegisterRequestBody;
import com.digiwin.processor.http.model.QueryRegisterResponseBody;
import com.digiwin.processor.model.ConsumerInfo;
import com.digiwin.processor.model.QueueInfo;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.digiwin.queue.saas.QueryRegisterEnum;
import com.digiwin.queue.saas.SaasClient;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.util.EntityUtils;

public class SaasClientImpl
extends SaasClient {
    private static final Log log = LogFactory.getLog(SaasClientImpl.class);
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private String tenantId;
    private String gatewayId;
    private String gatewayName;
    private String apName;
    private DWQueueReceiver receiver;
    protected Map<String, SaasClient.CompleteCallback> callbackMap = new HashMap<String, SaasClient.CompleteCallback>();
    protected Map<String, BlockingQueue<Boolean>> timeoutQueueMap = new HashMap<String, BlockingQueue<Boolean>>();
    protected Boolean initAmqp = false;
    private Channel saasChannel;

    @Override
    public String queryRegister(String tenantId, String apName, QueryRegisterEnum queryRegisterEnum) throws ProcessorContenctFailException, MqConnectFailException {
        return this.queryRegister(tenantId, apName, com.digiwin.processor.enums.QueryRegisterEnum.valueOf((String)queryRegisterEnum.toString()));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String queryRegister(String tenantId, String apName, com.digiwin.processor.enums.QueryRegisterEnum queryRegisterEnum) throws ProcessorContenctFailException, MqConnectFailException {
        if (tenantId == null && apName == null) {
            tJsonObject = new JsonObject();
            tJsonObject.addProperty("message", "at least one of tenantId or apName needs to be set");
            return tJsonObject.toString();
        }
        if (this.mqpHost != null) {
            tProcessorHost = this.mqpHost;
            if (SaasClientImpl.isIpPattern(tProcessorHost)) {
                tProcessorHost = tProcessorHost + ":8080";
            }
            tURL = "http://" + tProcessorHost + "/api/queryRegister";
            tRequestBody = new QueryRegisterRequestBody();
            tRequestBody.setTenantId(tenantId);
            tRequestBody.setApName(apName);
            tRequestBody.setQueryRegisterEnum(queryRegisterEnum);
            try {
                tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)SaasClientImpl.GSON.toJson((Object)tRequestBody));
                var8_14 = null;
                try {
                    if (tResponse.getStatusLine().getStatusCode() != 200) {
                        throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL + ":" + tResponse.toString());
                    }
                    tResponseBody = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                    tQueryRegisterResponse = (QueryRegisterResponseBody)SaasClientImpl.GSON.fromJson(tResponseBody, QueryRegisterResponseBody.class);
                    if (tQueryRegisterResponse.getSusccess().booleanValue()) {
                        tRegisterAPs = tQueryRegisterResponse.getApList();
                        var12_42 = SaasClientImpl.GSON.toJson((Object)tRegisterAPs);
                        return var12_42;
                    }
                    tRegisterAPs = tQueryRegisterResponse.getErrorMessage();
                    return tRegisterAPs;
                }
                catch (Throwable var9_20) {
                    var8_14 = var9_20;
                    throw var9_20;
                }
                finally {
                    if (tResponse != null) {
                        if (var8_14 != null) {
                            try {
                                tResponse.close();
                            }
                            catch (Throwable var13_51) {
                                var8_14.addSuppressed(var13_51);
                            }
                        } else {
                            tResponse.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProcessorContenctFailException(e.getMessage(), e);
            }
        }
        tCredentials = new UsernamePasswordCredentials(this.mqUserName, this.mqPassword);
        tGson = new Gson();
        tAlives = new JsonArray();
        tHostName = tenantId == null ? "" : tenantId + "_vhost";
        switch (6.$SwitchMap$com$digiwin$processor$enums$QueryRegisterEnum[queryRegisterEnum.ordinal()]) {
            case 1: {
                try {
                    tHttpResponse = HttpUtil.executHttpRequest((String)(this.url.toURI().toString() + "/queues/" + tHostName), (HttpMethod)HttpMethod.GET, (UsernamePasswordCredentials)tCredentials);
                    var9_21 = null;
                    try {
                        if (tHttpResponse.getStatusLine().getStatusCode() != 200) ** GOTO lbl60
                        tResponse = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity(), (Charset)Charsets.UTF_8);
                        tType = new TypeToken<ArrayList<QueueInfo>>(){}.getType();
                        tQueueInfos = (List)tGson.fromJson(tResponse, tType);
                        var13_52 = tQueueInfos.iterator();
                        ** GOTO lbl88
lbl60:
                        // 1 sources

                        tErrorMessage = "";
                        if (tHttpResponse.getEntity() != null) {
                            tErrorMessage = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
                        }
                        tJsonObject = new JsonObject();
                        tJsonObject.addProperty("status_code", (Number)tHttpResponse.getStatusLine().getStatusCode());
                        tJsonElement = new JsonParser().parse(tErrorMessage);
                        tJsonObject.add("message", tJsonElement);
                        tJsonObject.addProperty("message", tErrorMessage);
                        var13_53 = tJsonObject.toString();
                        if (tHttpResponse == null) return var13_53;
                        if (var9_21 != null) {
                        }
                        ** GOTO lbl110
                    }
                    catch (Exception e) {
                        SaasClientImpl.log.error((Object)e.getMessage(), (Throwable)e);
                        tJsonObject = new JsonObject();
                        tJsonObject.addProperty("erroe", e.getMessage());
                        tJsonElement = tJsonObject.toString();
                        if (tHttpResponse == null) return tJsonElement;
                        if (var9_21 != null) {
                            try {
                                tHttpResponse.close();
                                return tJsonElement;
                            }
                            catch (Throwable var13_54) {
                                var9_21.addSuppressed(var13_54);
                                return tJsonElement;
                            }
                        }
                        tHttpResponse.close();
                        return tJsonElement;
                    }
lbl88:
                    // 3 sources

                    while (var13_52.hasNext()) {
                        tQueueInfo = (QueueInfo)var13_52.next();
                        v0 = new Object[2];
                        v0[0] = tenantId == null ? "\\w+" : tenantId;
                        v1 = v0[1] = apName == null ? "\\w+" : apName;
                        if (!tQueueInfo.getName().matches(String.format("%s\\.\\w+\\.[^\\.]+\\.%s\\.queue", v0))) continue;
                        tQueueInfoParts = tQueueInfo.getName().split("\\.");
                        tAlive = new JsonObject();
                        tAlive.addProperty("tenantId", tQueueInfoParts[0]);
                        tAlive.addProperty("gatewayId", tQueueInfoParts[1]);
                        tAlive.addProperty("gatewayName", tQueueInfoParts[2]);
                        tAlive.addProperty("apName", tQueueInfoParts[3]);
                        tAlive.addProperty("isOnline", Boolean.valueOf(tQueueInfo.getConsumers() > 0));
                        tAlives.add((JsonElement)tAlive);
                    }
                    ** GOTO lbl112
                    try {
                        tHttpResponse.close();
                        return var13_53;
                    }
                    catch (Throwable tQueueInfo) {
                        var9_21.addSuppressed(tQueueInfo);
                        return var13_53;
                    }
lbl110:
                    // 1 sources

                    tHttpResponse.close();
                    return var13_53;
lbl112:
                    // 1 sources

                    if (tHttpResponse == null) return tAlives.toString();
                    if (var9_21 == null) {
                        tHttpResponse.close();
                        return tAlives.toString();
                    }
                    try {
                        tHttpResponse.close();
                        return tAlives.toString();
                    }
                    catch (Throwable e) {
                        var9_21.addSuppressed(e);
                        return tAlives.toString();
                    }
                    catch (Throwable e) {
                        try {
                            var9_21 = e;
                            throw e;
                        }
                        catch (Throwable var17_67) {
                            if (tHttpResponse == null) throw var17_67;
                            if (var9_21 == null) {
                                tHttpResponse.close();
                                throw var17_67;
                            }
                            try {
                                tHttpResponse.close();
                                throw var17_67;
                            }
                            catch (Throwable var18_68) {
                                var9_21.addSuppressed(var18_68);
                                throw var17_67;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new MqConnectFailException("Connect to MQ server failed", e);
                }
            }
            case 2: {
                try {
                    tHttpResponse = HttpUtil.executHttpRequest((String)(this.url.toURI().toString() + "/consumers/" + tHostName), (HttpMethod)HttpMethod.GET, (UsernamePasswordCredentials)tCredentials);
                    var9_22 = null;
                    try {
                        if (tHttpResponse.getStatusLine().getStatusCode() != 200) ** GOTO lbl162
                        tResponse = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity(), (Charset)Charsets.UTF_8);
                        tType = new TypeToken<ArrayList<ConsumerInfo>>(){}.getType();
                        tConsumerInfos = (List)tGson.fromJson(tResponse, tType);
                        for (ConsumerInfo tConsumerInfo : tConsumerInfos) {
                            v2 = new Object[2];
                            v2[0] = tenantId == null ? "\\w+" : tenantId;
                            v3 = v2[1] = apName == null ? "\\w+" : apName;
                            if (!tConsumerInfo.getConsumerTag().matches(String.format("%s\\.\\w+\\.[^\\.]+\\.%s", v2))) continue;
                            tConsumerTagParts = tConsumerInfo.getConsumerTag().split("\\.");
                            tAlive = new JsonObject();
                            tAlive.addProperty("tenantId", tConsumerTagParts[0]);
                            tAlive.addProperty("gatewayId", tConsumerTagParts[1]);
                            tAlive.addProperty("gatewayName", tConsumerTagParts[2]);
                            tAlive.addProperty("apName", tConsumerTagParts[3]);
                            tAlives.add((JsonElement)tAlive);
                        }
                        ** GOTO lbl216
lbl162:
                        // 1 sources

                        tErrorMessage = "";
                        if (tHttpResponse.getEntity() != null) {
                            tErrorMessage = EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
                        }
                        tJsonObject = new JsonObject();
                        tJsonObject.addProperty("status_code", (Number)tHttpResponse.getStatusLine().getStatusCode());
                        try {
                            tJsonElement = new JsonParser().parse(tErrorMessage);
                            tJsonObject.add("message", tJsonElement);
                        }
                        catch (JsonParseException e) {
                            tJsonObject.addProperty("message", tErrorMessage);
                        }
                        var12_48 = tJsonObject.toString();
                        if (tHttpResponse == null) return var12_48;
                        if (var9_22 != null) {
                        }
                        ** GOTO lbl214
                    }
                    catch (Exception e) {
                        SaasClientImpl.log.error((Object)e.getMessage(), (Throwable)e);
                        tJsonObject = new JsonObject();
                        tJsonObject.addProperty("erroe", e.getMessage());
                        var12_50 = tJsonObject.toString();
                        if (tHttpResponse == null) return var12_50;
                        if (var9_22 != null) {
                            try {
                                tHttpResponse.close();
                                return var12_50;
                            }
                            catch (Throwable var13_57) {
                                var9_22.addSuppressed(var13_57);
                                return var12_50;
                            }
                        }
                        tHttpResponse.close();
                        return var12_50;
                    }
                    catch (Throwable var10_33) {
                        try {
                            var9_22 = var10_33;
                            throw var10_33;
                        }
                        catch (Throwable var19_69) {
                            if (tHttpResponse == null) throw var19_69;
                            if (var9_22 == null) {
                                tHttpResponse.close();
                                throw var19_69;
                            }
                            try {
                                tHttpResponse.close();
                                throw var19_69;
                            }
                            catch (Throwable var20_70) {
                                var9_22.addSuppressed(var20_70);
                                throw var19_69;
                            }
                        }
                    }
                    try {
                        tHttpResponse.close();
                        return var12_48;
                    }
                    catch (Throwable var13_56) {
                        var9_22.addSuppressed(var13_56);
                        return var12_48;
                    }
lbl214:
                    // 1 sources

                    tHttpResponse.close();
                    return var12_48;
lbl216:
                    // 1 sources

                    if (tHttpResponse == null) return tAlives.toString();
                    if (var9_22 == null) {
                        tHttpResponse.close();
                        return tAlives.toString();
                    }
                    try {
                        tHttpResponse.close();
                        return tAlives.toString();
                    }
                    catch (Throwable var10_32) {
                        var9_22.addSuppressed(var10_32);
                        return tAlives.toString();
                    }
                }
                catch (Exception e) {
                    throw new MqConnectFailException("Connect to MQ server failed", e);
                }
            }
        }
        return tAlives.toString();
    }

    @Override
    public void onSend(String tenantId, String gatewayID, String message) throws Exception {
        this.onSend(tenantId, gatewayID, message, null, null, null, null);
    }

    @Override
    public void onSend(String tenantId, String gatewayID, String message, SaasClient.CompleteCallback completeCallback) throws Exception {
        this.onSend(tenantId, gatewayID, message, completeCallback, null, 2, TimeUnit.HOURS);
    }

    @Override
    public void onSend(String tenantId, String gatewayID, String message, SaasClient.TimeoutCallback timeoutCallback, Integer timeout, TimeUnit timeoutUnit) throws Exception {
        this.onSend(tenantId, gatewayID, message, null, timeoutCallback, timeout, timeoutUnit);
    }

    @Override
    public void onSend(String tenantId, String gatewayID, final String message, final SaasClient.CompleteCallback completeCallback, final SaasClient.TimeoutCallback timeoutCallback, final Integer timeout, final TimeUnit timeoutUnit) throws Exception {
        Long tTimeout = null;
        if (timeout != null && timeoutUnit != null) {
            tTimeout = timeoutUnit.toMillis(timeout.intValue());
        }
        final ExecuteWrapper tWrapper = this.executeSend(tenantId, gatewayID, message, completeCallback, tTimeout);
        final Channel tChannel = tWrapper.getChannel();
        if (tWrapper != null) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            BlockingQueue<Boolean> response = tWrapper.getResponse();
                            String tCorrelationId = tWrapper.getCorrelationId();
                            String topic = tWrapper.getTopic();
                            Boolean result = response.poll(timeout.longValue(), timeoutUnit);
                            if (result != null) break block8;
                            SaasClientImpl.this.callbackMap.remove(tCorrelationId);
                            SaasClientImpl.this.timeoutQueueMap.remove(tCorrelationId);
                            JsonObject jo = new JsonObject();
                            jo.addProperty("topic", topic);
                            jo.addProperty("result", Boolean.valueOf(false));
                            jo.addProperty("message", message);
                            jo.add("detail", (JsonElement)new JsonArray());
                            if (timeoutCallback != null) {
                                timeoutCallback.onCallback(jo.toString());
                            } else if (completeCallback != null) {
                                completeCallback.onCallback(jo.toString());
                            }
                            try {
                                if (tChannel != null && tChannel.isOpen()) {
                                    tChannel.abort();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void onStandardBroadcast(String tenantId, String message) throws Exception {
        this.onStandardBroadcast(tenantId, null, message);
    }

    @Override
    public void onStandardBroadcast(String tenantId, String apName, String message) throws Exception {
        Connection tTenantConnection = this.getTenantConnection(tenantId);
        RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(tenantId, null, null, apName);
        if (apName == null) {
            this.publishMessage(tTenantConnection, topicSupporter.getExchangeName(), topicSupporter.getTenantTopic(), null, message);
        } else {
            this.publishMessage(tTenantConnection, topicSupporter.getExchangeName(), topicSupporter.getApTopic(), null, message);
        }
    }

    private ExecuteWrapper executeSend(String tenantId, String gatewayId, String message, SaasClient.CompleteCallback completeCallback, Long timeout) throws Exception {
        String tCorrelationId = UUID.randomUUID().toString();
        if (completeCallback != null) {
            this.callbackMap.put(tCorrelationId, completeCallback);
        }
        Map.Entry<String, Channel> replyInfo = this.createReply();
        String replyName = replyInfo.getKey();
        Channel channel = replyInfo.getValue();
        Connection tTenantConnection = this.getTenantConnection(tenantId);
        RabbitmqTopicSupporter topicSupporter = new RabbitmqTopicSupporter(tenantId, gatewayId, null, null);
        if (timeout != null) {
            AMQP.BasicProperties.Builder tBuilder = new AMQP.BasicProperties.Builder().correlationId(tCorrelationId).replyTo(replyName).expiration(timeout.toString());
            AMQP.BasicProperties props = tBuilder.build();
            ArrayBlockingQueue<Boolean> response = new ArrayBlockingQueue<Boolean>(1);
            this.timeoutQueueMap.put(tCorrelationId, response);
            this.publishMessage(tTenantConnection, topicSupporter.getExchangeName(), topicSupporter.getPublishKey(), props, message);
            ExecuteWrapper executeWrapper = new ExecuteWrapper(tCorrelationId, response, topicSupporter.getMainTopic(), channel);
            return executeWrapper;
        }
        this.publishMessage(tTenantConnection, topicSupporter.getExchangeName(), topicSupporter.getPublishKey(), null, message);
        return null;
    }

    @Override
    public void registerSaas(String tenantId, String gatewayId, String gatewayName, String apName, DWQueueReceiver receiver) throws Exception {
        Objects.requireNonNull(receiver, "receiver cant't be null");
        this.tenantId = tenantId;
        this.gatewayId = gatewayId;
        this.gatewayName = gatewayName;
        this.apName = apName;
        this.receiver = receiver;
        this.initAmqp();
    }

    private String consumerTagParse(String ... pNamespaces) {
        StringBuilder tConsumerTagBuilder = new StringBuilder();
        for (String tNamespace : pNamespaces) {
            tConsumerTagBuilder.append(tNamespace).append(".");
        }
        tConsumerTagBuilder.deleteCharAt(tConsumerTagBuilder.length() - 1);
        return tConsumerTagBuilder.toString();
    }

    private Connection getTenantConnection(String pTenantId) throws Exception {
        Connection tTenantConnection = (Connection)this.tenantConnectionMap.get(pTenantId);
        if (tTenantConnection == null || !tTenantConnection.isOpen()) {
            tTenantConnection = this.getConnection(pTenantId + "_vhost");
            this.tenantConnectionMap.put(pTenantId, tTenantConnection);
        }
        return tTenantConnection;
    }

    private Map.Entry<String, Channel> createReply() throws Exception {
        if (this.saasConnection == null || !this.saasConnection.isOpen()) {
            this.saasConnection = this.getConnection("/");
        }
        final Channel tSaasChannel = this.saasConnection.createChannel();
        String replyName = UUID.randomUUID().toString() + ".reply";
        HashMap<String, Long> tQueueArgs = new HashMap<String, Long>();
        tQueueArgs.put("x-expires", TimeUnit.MINUTES.toMillis(2L));
        tSaasChannel.queueDeclare(replyName, false, false, true, tQueueArgs);
        tSaasChannel.basicConsume(replyName, false, (Consumer)new DefaultConsumer(tSaasChannel){

            public void handleDelivery(final String consumerTag, final Envelope envelope, final AMQP.BasicProperties properties, final byte[] body) throws IOException {
                SaasClientImpl.this.executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (properties != null) {
                            String tCorrelationId = properties.getCorrelationId();
                            String tMessage = new String(body, Charsets.UTF_8);
                            try {
                                if (SaasClientImpl.this.callbackMap.containsKey(tCorrelationId)) {
                                    JsonElement tReceiver = new JsonParser().parse(tMessage);
                                    JsonObject tRetrunJo = new JsonObject();
                                    JsonArray tReceiverJa = new JsonArray();
                                    tReceiverJa.add(tReceiver);
                                    tRetrunJo.addProperty("result", Boolean.valueOf(true));
                                    tRetrunJo.add("detail", (JsonElement)tReceiverJa);
                                    SaasClientImpl.this.callbackMap.remove(tCorrelationId).onCallback(tRetrunJo.toString());
                                } else {
                                    log.info((Object)("Invalid correlationId: " + tCorrelationId));
                                }
                                if (SaasClientImpl.this.timeoutQueueMap.containsKey(tCorrelationId)) {
                                    SaasClientImpl.this.timeoutQueueMap.remove(tCorrelationId).offer(true);
                                }
                                tSaasChannel.basicAck(envelope.getDeliveryTag(), false);
                                tSaasChannel.basicCancel(consumerTag);
                            }
                            catch (IOException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                            finally {
                                try {
                                    if (tSaasChannel != null) {
                                        tSaasChannel.abort();
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        });
        log.info((Object)("Consumer replyQueue: " + replyName));
        this.enableHeartbeat();
        AbstractMap.SimpleEntry<String, Channel> result = new AbstractMap.SimpleEntry<String, Channel>(replyName, tSaasChannel);
        return result;
    }

    private void initAmqp() throws Exception {
        if (this.saasConnection == null || !this.saasConnection.isOpen()) {
            this.saasConnection = this.getConnection("/");
        }
        RabbitmqTopicSupporter tTopicSupporter = new RabbitmqTopicSupporter(this.tenantId, this.gatewayId, this.gatewayName, this.apName);
        String consumerTag = this.consumerTagParse(this.tenantId, this.gatewayId, this.gatewayName, this.apName);
        this.saasChannel = this.saasConnection.createChannel();
        DefaultConsumer tConsumer = new DefaultConsumer(this.saasChannel){

            public void handleDelivery(String consumerTag, final Envelope envelope, final AMQP.BasicProperties properties, final byte[] body) throws IOException {
                SaasClientImpl.this.executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String tMessage = new String(body);
                        String tReturn = SaasClientImpl.this.receiver.execute(tMessage);
                        tReturn = Objects.toString(tReturn, "");
                        try {
                            if (properties.getCorrelationId() != null) {
                                String tReplyTenantId = properties.getHeaders().get("tenantId").toString();
                                Connection tReplyTenantConnection = SaasClientImpl.this.getTenantConnection(tReplyTenantId);
                                AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(properties.getCorrelationId()).build();
                                int count = 0;
                                while (true) {
                                    Channel tReplyChannel = null;
                                    try {
                                        tReplyChannel = tReplyTenantConnection.createChannel();
                                        tReplyChannel.confirmSelect();
                                        tReplyChannel.basicPublish("", properties.getReplyTo(), replyProps, tReturn.getBytes("UTF-8"));
                                        tReplyChannel.waitForConfirmsOrDie();
                                    }
                                    catch (Exception e) {
                                        if (++count == SaasClientImpl.this.retryTimes) {
                                            log.error((Object)e.getMessage(), (Throwable)e);
                                            break;
                                        }
                                        try {
                                            Thread.sleep(SaasClientImpl.this.retryInterval);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            interruptedException.printStackTrace();
                                        }
                                        continue;
                                    }
                                    finally {
                                        try {
                                            if (tReplyChannel == null) continue;
                                            tReplyChannel.abort();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        continue;
                                    }
                                    break;
                                }
                            }
                            this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        };
        this.saasChannel.exchangeDeclare(tTopicSupporter.getExchangeName(), BuiltinExchangeType.TOPIC, true);
        this.saasChannel.queueDeclare(tTopicSupporter.getQueueName(), true, false, false, null);
        this.saasChannel.queueBind(tTopicSupporter.getQueueName(), tTopicSupporter.getExchangeName(), tTopicSupporter.getWildcardTopic());
        this.saasChannel.basicConsume(tTopicSupporter.getQueueName(), false, consumerTag, (Consumer)tConsumer);
        log.info((Object)("Register queue: " + tTopicSupporter.getQueueName()));
        this.initAmqp = true;
        this.enableHeartbeat();
    }

    public void doHeartbeat() {
        try {
            if (this.initAmqp.booleanValue()) {
                if (this.saasConnection == null || !this.saasConnection.isOpen()) {
                    log.warn((Object)"MQ connection is closed, recover");
                    this.initAmqp();
                } else if (this.saasChannel == null || !this.saasChannel.isOpen()) {
                    log.warn((Object)"MQ channel is closed, recover");
                    this.initAmqp();
                } else {
                    RabbitmqTopicSupporter tTopicSupporter = new RabbitmqTopicSupporter(this.tenantId, this.gatewayId, this.gatewayName, this.apName);
                    long consumerCount = this.saasChannel.consumerCount(tTopicSupporter.getQueueName());
                    if (consumerCount == 0L) {
                        log.warn((Object)"MQ consumer is closed, recover");
                        this.initAmqp();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private class ExecuteWrapper {
        private String correlationId;
        private BlockingQueue<Boolean> response;
        private String topic;
        private Channel channel;

        public ExecuteWrapper(String correlationId, BlockingQueue<Boolean> response, String topic, Channel channel) {
            this.correlationId = correlationId;
            this.response = response;
            this.topic = topic;
            this.channel = channel;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public BlockingQueue<Boolean> getResponse() {
            return this.response;
        }

        public String getTopic() {
            return this.topic;
        }
    }
}

