/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.saas;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.http.model.SaasConnectionRequestBody;
import com.digiwin.processor.http.model.SaasConnectionResponseBody;
import com.digiwin.processor.model.MqInfo;
import com.digiwin.queue.Client;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.digiwin.queue.exceptions.TokenVerificationFailedException;
import com.digiwin.queue.saas.QueryRegisterEnum;
import com.digiwin.queue.saas.SaasClientImpl;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public abstract class SaasClient
extends Client {
    private static final Log log = LogFactory.getLog(SaasClient.class);
    protected static final String QUEUE_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s\\.queue";
    protected static final String CONSUMER_TAG_REGEX = "%s\\.\\w+\\.[^\\.]+\\.%s";
    protected static final Pattern IP = Pattern.compile("^((([0-9]{1,3}\\.){3})[0-9]{1,3})$");
    protected static final Gson GSON = new Gson();
    protected String mqpHost;
    protected URL url;
    protected Connection saasConnection;
    protected Map<String, Connection> tenantConnectionMap = new HashMap<String, Connection>();

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword);
    }

    @Deprecated
    public static SaasClient init(String processorHost, String mqHost, String mqUserName, String mqPassword, Integer retryTimes, Long retryInterval) {
        return SaasClient.init(null, processorHost, mqHost, null, null, mqUserName, mqPassword, retryTimes, retryInterval);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword) {
        return SaasClient.init(protocol, processorHost, mqHost, amqpPort, protocolPort, mqUserName, mqPassword, 3, 5000L);
    }

    @Deprecated
    public static SaasClient init(Protocol protocol, String processorHost, String mqHost, Integer amqpPort, Integer protocolPort, String mqUserName, String mqPassword, int retryTimes, long retryInterval) {
        SaasClientImpl instance = new SaasClientImpl();
        instance.setProp(mqHost, amqpPort, amqpPort, mqUserName, mqPassword);
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        SaasClient.setProcessorUrl((String)processorHost);
        if (protocol == null) {
            protocol = Protocol.HTTP;
        }
        try {
            instance.url = protocolPort != null ? (SaasClient.isIpPattern(mqHost) ? new URL(protocol.toString(), mqHost, protocolPort, "/api") : new URL(protocol.toString(), mqHost, "/api")) : new URL(protocol.toString(), mqHost, "/api");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return instance;
    }

    public static SaasClient init(String mqpHost, String token) throws ProcessorContenctFailException, TokenVerificationFailedException {
        return SaasClient.init(mqpHost, token, 3, 5000L);
    }

    public static SaasClient init(String mqpHost, String token, int retryTimes, long retryInterval) throws ProcessorContenctFailException, TokenVerificationFailedException {
        SaasClientImpl instance;
        block17: {
            instance = new SaasClientImpl();
            instance.mqpHost = mqpHost;
            String tProcessorHost = instance.mqpHost;
            if (SaasClient.isIpPattern(tProcessorHost)) {
                tProcessorHost = tProcessorHost + ":8080";
            }
            String tURL = "http://" + tProcessorHost + "/api/saasConnecation";
            SaasConnectionRequestBody tRequestBody = new SaasConnectionRequestBody();
            tRequestBody.setToken(token);
            try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)GSON.toJson((Object)tRequestBody));){
                if (tResponse.getStatusLine().getStatusCode() != 200) {
                    throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL + ":" + tResponse.toString());
                }
                String tResponseBody = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                SaasConnectionResponseBody tSaasConnectionResponseBody = (SaasConnectionResponseBody)GSON.fromJson(tResponseBody, SaasConnectionResponseBody.class);
                if (tSaasConnectionResponseBody.getSuccess().booleanValue()) {
                    MqInfo tMqInfo = tSaasConnectionResponseBody.getMqInfo();
                    instance.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), tMqInfo.getMqUser(), new String(Base64.decodeBase64((String)tMqInfo.getMqPasswordEncoded())));
                    break block17;
                }
                throw new TokenVerificationFailedException(tSaasConnectionResponseBody.getMessage());
            }
            catch (IOException e) {
                throw new ProcessorContenctFailException(e.getMessage(), (Exception)e);
            }
        }
        instance.retryTimes = retryTimes;
        instance.retryInterval = retryInterval;
        SaasClient.setProcessorUrl((String)mqpHost);
        return instance;
    }

    @Deprecated
    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3, boolean var4) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String queryRegister(String var1, String var2, com.digiwin.processor.enums.QueryRegisterEnum var3, boolean var4) throws ProcessorContenctFailException, MqConnectFailException;

    @Deprecated
    public abstract String queryRegister(String var1, String var2, QueryRegisterEnum var3) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String queryRegister(String var1, String var2, com.digiwin.processor.enums.QueryRegisterEnum var3) throws ProcessorContenctFailException, MqConnectFailException;

    public abstract String onSyncSend(String var1, String var2, String var3, boolean var4) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3, Integer var4, TimeUnit var5, boolean var6) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3) throws Exception;

    public abstract String onSyncSend(String var1, String var2, String var3, Integer var4, TimeUnit var5) throws Exception;

    public abstract void onSend(String var1, String var2, String var3) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, TimeoutCallback var4, Integer var5, TimeUnit var6) throws Exception;

    public abstract void onSend(String var1, String var2, String var3, CompleteCallback var4, TimeoutCallback var5, Integer var6, TimeUnit var7) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2) throws Exception;

    public abstract void onStandardBroadcast(String var1, String var2, String var3) throws Exception;

    public abstract void registerSaas(String var1, String var2, String var3, String var4, DWQueueReceiver var5) throws Exception;

    public void close() {
        this.disableHeartbeat();
        if (this.saasConnection != null) {
            try {
                this.saasConnection.abort();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (Connection tConnection : this.tenantConnectionMap.values()) {
            try {
                tConnection.abort();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessage(Connection connection, String exchangeName, String routingKey, AMQP.BasicProperties props, String message) throws Exception {
        int count = 0;
        while (true) {
            Channel tChannel = null;
            try {
                tChannel = connection.createChannel();
                tChannel.confirmSelect();
                tChannel.basicPublish(exchangeName, routingKey, props, message.getBytes("UTF-8"));
                tChannel.waitForConfirmsOrDie();
            }
            catch (Exception e) {
                if (++count == this.retryTimes) {
                    throw e;
                }
                log.warn((Object)"Publish message failed,retry");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            finally {
                if (tChannel == null) continue;
                try {
                    tChannel.abort();
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    protected static boolean isIpPattern(String host) {
        return IP.matcher(host).matches();
    }

    public static interface TimeoutCallback {
        public void onCallback(String var1);
    }

    public static interface CompleteCallback {
        public void onCallback(String var1);
    }

    public static enum Protocol {
        HTTP,
        HTTPS;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

