/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.tenant;

import com.digiwin.app.queue.DWQueueReceiver;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWQueueConsumer
extends DefaultConsumer {
    private static final Log log = LogFactory.getLog(DWQueueConsumer.class);
    private DWQueueReceiver receiver;
    private ExecutorService executorService;
    private Connection saasConnection;

    public DWQueueConsumer(Channel channel, DWQueueReceiver receiver, ExecutorService executorService, Connection saasConnection) {
        super(channel);
        this.receiver = receiver;
        this.executorService = executorService;
        this.saasConnection = saasConnection;
    }

    public void handleDelivery(String consumerTag, final Envelope envelope, final AMQP.BasicProperties properties, byte[] body) throws IOException {
        final String tMessage = new String(body, Charsets.UTF_8);
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String tReturn = null;
                if (DWQueueConsumer.this.receiver != null) {
                    tReturn = DWQueueConsumer.this.receiver.execute(tMessage);
                    tReturn = Objects.toString(tReturn, "");
                    try {
                        if (properties.getCorrelationId() != null) {
                            AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(properties.getCorrelationId()).build();
                            int count = 0;
                            while (true) {
                                Channel tSaasChannel = null;
                                try {
                                    tSaasChannel = DWQueueConsumer.this.saasConnection.createChannel();
                                    tSaasChannel.confirmSelect();
                                    tSaasChannel.basicPublish("", properties.getReplyTo(), replyProps, tReturn.getBytes("UTF-8"));
                                    tSaasChannel.waitForConfirmsOrDie();
                                }
                                catch (Exception e) {
                                    if (++count == 3) {
                                        log.error((Object)e.getMessage(), (Throwable)e);
                                        break;
                                    }
                                    log.warn((Object)("Conusmer callback failed,retry." + System.lineSeparator() + "Get message: " + tMessage + System.lineSeparator() + "Return: " + tReturn));
                                    try {
                                        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                    continue;
                                }
                                finally {
                                    try {
                                        if (tSaasChannel == null) continue;
                                        tSaasChannel.close();
                                    }
                                    catch (TimeoutException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                break;
                            }
                        }
                        DWQueueConsumer.this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
    }
}

