/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.queue.tenant;

import com.digiwin.app.queue.DWQueueReceiver;
import com.digiwin.processor.enums.HttpMethod;
import com.digiwin.processor.http.model.RegisterRequestBody;
import com.digiwin.processor.http.model.RegisterResponseBody;
import com.digiwin.processor.model.MqInfo;
import com.digiwin.queue.HttpUtil;
import com.digiwin.queue.RabbitmqTopicSupporter;
import com.digiwin.queue.exceptions.MqConnectFailException;
import com.digiwin.queue.exceptions.ProcessorContenctFailException;
import com.digiwin.queue.tenant.TenantClient;
import com.digiwin.queue.tenant.model.RegisterResult;
import com.google.gson.Gson;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class TenantClientImpl
extends TenantClient {
    private static final Log log = LogFactory.getLog(TenantClientImpl.class);
    private String tenantId;
    private String gatewayId;
    private String gatewayName;
    private String apName;
    private DWQueueReceiver receiver;
    private String queueName;

    @Override
    public String onRegister(String gatewayName, String apName, String authKey, DWQueueReceiver receiver) {
        this.gatewayName = gatewayName;
        this.apName = apName;
        RegisterResult tResult = new RegisterResult();
        if (this.tenantConnecion != null && this.tenantConnecion.isOpen()) {
            log.warn((Object)"Already registered, close the connection");
            this.close();
        }
        try {
            RegisterRequestBody tRequestBody = new RegisterRequestBody();
            tRequestBody.setGatewayName(gatewayName);
            tRequestBody.setApName(apName);
            tRequestBody.setauthKey(authKey);
            String tURL = this.processorUrl + "api/register";
            String tJson = new Gson().toJson((Object)tRequestBody);
            String tResponseStr = null;
            int count = 0;
            log.info((Object)"Connection to MQ Processor");
            while (true) {
                try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)tJson);){
                    log.info((Object)("MQ Processor response: " + tResponse));
                    if (tResponse.getStatusLine().getStatusCode() != 200) {
                        throw new ProcessorContenctFailException(tResponse.toString());
                    }
                    tResponseStr = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    if (++count == this.retryTimes) {
                        throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL, e);
                    }
                    log.warn((Object)("Connect to MQ processor failed:" + tURL + ",retry"));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            RegisterResponseBody tRegisterResponseBody = (RegisterResponseBody)new Gson().fromJson(tResponseStr, RegisterResponseBody.class);
            if (tRegisterResponseBody.getResult().booleanValue()) {
                this.tenantId = tRegisterResponseBody.getTenantId();
                String tTenantSid = tRegisterResponseBody.getTenantSid();
                this.gatewayId = tRegisterResponseBody.getMqInfo().getGatewayId();
                String tToken = tRegisterResponseBody.getToken();
                MqInfo tMqInfo = tRegisterResponseBody.getMqInfo();
                this.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), tMqInfo.getMqUser(), new String(Base64.decodeBase64((String)tMqInfo.getMqPasswordEncoded())));
                if (receiver != null) {
                    this.receiver = receiver;
                    RabbitmqTopicSupporter tTopicSupporter = new RabbitmqTopicSupporter(this.tenantId, this.gatewayId, gatewayName, apName);
                    this.queueName = tTopicSupporter.getQueueName();
                    this.initAmqp();
                    this.enableHeartbeat();
                }
                tResult.setResult(true);
                tResult.setTenantId(this.tenantId);
                tResult.setTenantSid(tTenantSid);
                tResult.setGatewayId(this.gatewayId);
                tResult.setToken(tToken);
            } else {
                tResult.setResult(false);
                tResult.setDescription("Processor:" + tRegisterResponseBody.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof MqConnectFailException || e instanceof ProcessorContenctFailException) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            tResult.setResult(false);
            tResult.setDescription(e.getMessage());
        }
        return new Gson().toJson((Object)tResult);
    }

    private String consumerTagParse(String ... pNamespaces) {
        StringBuilder tConsumerTagBuilder = new StringBuilder();
        for (String tNamespace : pNamespaces) {
            tConsumerTagBuilder.append(tNamespace).append(".");
        }
        tConsumerTagBuilder.deleteCharAt(tConsumerTagBuilder.length() - 1);
        return tConsumerTagBuilder.toString();
    }

    @Override
    @Deprecated
    public String onRegisterV01(String gatewayName, String apName, String userName, String pwHash) {
        RegisterResult tResult = new RegisterResult();
        String tTenantId = null;
        String tGatewayID = null;
        if (this.tenantConnecion != null && this.tenantConnecion.isOpen()) {
            log.warn((Object)"Already registered, close the connection");
            this.close();
        }
        try {
            RegisterRequestBody tRequestBody = new RegisterRequestBody();
            tRequestBody.setGatewayName(gatewayName);
            tRequestBody.setApName(apName);
            tRequestBody.setUserId(userName);
            tRequestBody.setPwHash(pwHash);
            String tURL = this.processorUrl + "api/registerV01";
            String tJson = new Gson().toJson((Object)tRequestBody);
            String tResponseStr = null;
            int count = 0;
            while (true) {
                try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)tJson);){
                    tResponseStr = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    if (++count == this.retryTimes) {
                        throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL, e);
                    }
                    log.warn((Object)("Connect to MQ processor failed:" + tURL + ",retry"));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            RegisterResponseBody tRegisterResponseBody = (RegisterResponseBody)new Gson().fromJson(tResponseStr, RegisterResponseBody.class);
            if (tRegisterResponseBody.getResult().booleanValue()) {
                tTenantId = tRegisterResponseBody.getTenantId();
                tGatewayID = tRegisterResponseBody.getMqInfo().getGatewayId();
                MqInfo tMqInfo = tRegisterResponseBody.getMqInfo();
                this.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), tMqInfo.getMqUser(), new String(Base64.decodeBase64((String)tMqInfo.getMqPasswordEncoded())));
                tResult.setResult(true);
                tResult.setTenantId(tTenantId);
                tResult.setGatewayId(tGatewayID);
            } else {
                tResult.setResult(false);
                tResult.setDescription("Processor:" + tRegisterResponseBody.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof MqConnectFailException || e instanceof ProcessorContenctFailException) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            tResult.setResult(false);
            tResult.setDescription(e.getMessage());
        }
        return new Gson().toJson((Object)tResult);
    }

    @Override
    @Deprecated
    public String onReRegisterV01(String gatewayID, String gatewayName, String apName) {
        RegisterResult tResult = new RegisterResult();
        String tTenantId = null;
        if (this.tenantConnecion != null && this.tenantConnecion.isOpen()) {
            log.warn((Object)"Already registered, close the connection");
            this.close();
        }
        try {
            RegisterRequestBody tRequestBody = new RegisterRequestBody();
            tRequestBody.setGatewayId(gatewayID);
            tRequestBody.setGatewayName(gatewayName);
            tRequestBody.setApName(apName);
            String tURL = this.processorUrl + "api/registerV01";
            String tJson = new Gson().toJson((Object)tRequestBody);
            String tResponseStr = null;
            int count = 0;
            while (true) {
                try (CloseableHttpResponse tResponse = HttpUtil.executHttpRequest((String)tURL, (HttpMethod)HttpMethod.POST, (String)tJson);){
                    tResponseStr = EntityUtils.toString((HttpEntity)tResponse.getEntity(), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    if (++count == this.retryTimes) {
                        throw new ProcessorContenctFailException("Connect to MQ processor failed:" + tURL, e);
                    }
                    log.warn((Object)("Connect to MQ processor failed:" + tURL + ",retry"));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            RegisterResponseBody tRegisterResponseBody = (RegisterResponseBody)new Gson().fromJson(tResponseStr, RegisterResponseBody.class);
            if (tRegisterResponseBody.getResult().booleanValue()) {
                tTenantId = tRegisterResponseBody.getTenantId();
                MqInfo tMqInfo = tRegisterResponseBody.getMqInfo();
                this.setProp(tMqInfo.getMqHost(), tMqInfo.getMqAmqpPort(), tMqInfo.getMqAmqpSslPort(), tMqInfo.getMqUser(), new String(Base64.decodeBase64((String)tMqInfo.getMqPasswordEncoded())));
                tResult.setResult(true);
                tResult.setTenantId(tTenantId);
                tResult.setGatewayId(gatewayID);
            } else {
                tResult.setResult(false);
                tResult.setDescription("Processor:" + tRegisterResponseBody.getMessage());
            }
        }
        catch (Exception e) {
            if (e instanceof MqConnectFailException || e instanceof ProcessorContenctFailException) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            tResult.setResult(false);
            tResult.setDescription(e.getMessage());
        }
        return new Gson().toJson((Object)tResult);
    }

    @Override
    @Deprecated
    public void onTopicV01(String tenantId, String gatewayId, String gatewayName, String apName, DWQueueReceiver receiver) throws Exception {
        this.tenantId = tenantId;
        this.gatewayId = gatewayId;
        this.gatewayName = gatewayName;
        this.apName = apName;
        if (receiver != null) {
            this.receiver = receiver;
            RabbitmqTopicSupporter tTopicSupporter = new RabbitmqTopicSupporter(tenantId, gatewayId, gatewayName, apName);
            this.queueName = tTopicSupporter.getQueueNameV01();
            this.initAmqp();
            this.enableHeartbeat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendToSaas(String tenantId, String saasTenantId, String saasGatewayId, String message, Long timeout) throws MqConnectFailException, TimeoutException, Exception {
        RabbitmqTopicSupporter tTopicSupporter = new RabbitmqTopicSupporter(saasTenantId, saasGatewayId, null, null);
        final String tCorrelationId = UUID.randomUUID().toString();
        Channel tReplyChannel = null;
        String tResMessage = null;
        try {
            tReplyChannel = this.tenantConnecion.createChannel();
            String tReplyQueueName = tReplyChannel.queueDeclare().getQueue();
            HashMap<String, String> tHeaders = new HashMap<String, String>();
            tHeaders.put("tenantId", tenantId);
            AMQP.BasicProperties.Builder tBuilder = new AMQP.BasicProperties.Builder().correlationId(tCorrelationId).replyTo(tReplyQueueName).headers(tHeaders).expiration(timeout.toString());
            AMQP.BasicProperties tProps = tBuilder.build();
            final ArrayBlockingQueue tResQueue = new ArrayBlockingQueue(1);
            String tConsumerTag = tReplyChannel.basicConsume(tReplyQueueName, true, (Consumer)new DefaultConsumer(tReplyChannel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (properties != null && properties.getCorrelationId().equals(tCorrelationId)) {
                        String message = new String(body, "UTF-8");
                        tResQueue.offer(message);
                    }
                }
            });
            if (this.saasConnection == null || !this.saasConnection.isOpen()) {
                this.saasConnection = this.getConnection("/");
            }
            this.publishMessageToSaas(this.saasConnection, tTopicSupporter, tProps, message);
            tResMessage = (String)tResQueue.poll(timeout, TimeUnit.MILLISECONDS);
            tReplyChannel.basicCancel(tConsumerTag);
            if (tResMessage == null) {
                throw new TimeoutException();
            }
        }
        finally {
            try {
                tReplyChannel.close();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return tResMessage;
    }

    private void initAmqp() throws Exception {
        if (this.tenantConnecion == null || !this.tenantConnecion.isOpen()) {
            this.tenantConnecion = this.getConnection(this.tenantId + "_vhost");
        }
        Channel tChannel = this.tenantConnecion.createChannel();
        log.info((Object)("Consume Queue: " + this.queueName));
        DefaultConsumer tConsumer = new DefaultConsumer(tChannel){

            public void handleDelivery(String consumerTag, final Envelope envelope, final AMQP.BasicProperties properties, byte[] body) throws IOException {
                final String tMessage = new String(body, Charsets.UTF_8);
                TenantClient.executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String tReturn = null;
                        if (TenantClientImpl.this.receiver != null) {
                            tReturn = TenantClientImpl.this.receiver.execute(tMessage);
                            tReturn = Objects.toString(tReturn, "");
                            try {
                                if (properties.getCorrelationId() != null) {
                                    AMQP.BasicProperties replyProps = new AMQP.BasicProperties.Builder().correlationId(properties.getCorrelationId()).build();
                                    int count = 0;
                                    while (true) {
                                        Channel tSaasChannel = null;
                                        try {
                                            if (TenantClientImpl.this.saasConnection == null || !TenantClientImpl.this.saasConnection.isOpen()) {
                                                TenantClientImpl.this.saasConnection = TenantClientImpl.this.getConnection("/");
                                            }
                                            tSaasChannel = TenantClientImpl.this.saasConnection.createChannel();
                                            tSaasChannel.confirmSelect();
                                            tSaasChannel.basicPublish("", properties.getReplyTo(), replyProps, tReturn.getBytes("UTF-8"));
                                            tSaasChannel.waitForConfirmsOrDie();
                                        }
                                        catch (Exception e) {
                                            if (++count == TenantClientImpl.this.retryTimes) {
                                                log.error((Object)e.getMessage(), (Throwable)e);
                                                break;
                                            }
                                            log.warn((Object)("Conusmer callback failed,retry." + System.lineSeparator() + "Get message: " + tMessage + System.lineSeparator() + "Return: " + tReturn));
                                            try {
                                                Thread.sleep(TenantClientImpl.this.retryInterval);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                interruptedException.printStackTrace();
                                            }
                                            continue;
                                        }
                                        finally {
                                            try {
                                                if (tSaasChannel == null) continue;
                                                tSaasChannel.close();
                                            }
                                            catch (TimeoutException e) {
                                                e.printStackTrace();
                                            }
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                            }
                            catch (IOException e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
            }
        };
        String tConsumerTag = this.consumerTagParse(this.tenantId, this.gatewayId, this.gatewayName, this.apName);
        tChannel.basicConsume(this.queueName, false, tConsumerTag, (Consumer)tConsumer);
        log.info((Object)"Consume success");
    }

    protected void doHeartbeat() {
        if (this.tenantConnecion == null || !this.tenantConnecion.isOpen()) {
            log.warn((Object)"MQ connection is closed, recover");
            try {
                this.initAmqp();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

