/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.context;

import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.service.DWJobService;
import com.digiwin.app.schedule.service.DWScheduleService;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DWScheduleContext {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleContext]";
    private final Log log = LogFactory.getLog(this.getClass());
    private static DWScheduleContext instance = null;
    private DWScheduleDBService scheduleDBService = DWScheduleDBService.getInstance();
    private DWScheduleTimeDBService scheduleTimeDBService = DWScheduleTimeDBService.getInstance();
    private DWScheduleRecordDBService scheduleRecordDBService = DWScheduleRecordDBService.getInstance();
    private DWScheduleContactDBService scheduleContactDBService = DWScheduleContactDBService.getInstance();
    private DWScheduleService scheduleService = DWScheduleService.getInstance();
    private DWJobService jobService = DWJobService.getInstance();

    public static synchronized DWScheduleContext getInstance() {
        if (instance == null) {
            instance = (DWScheduleContext)SpringContextUtils.getBean((String)"DWScheduleContext");
        }
        return instance;
    }

    public Object executeJob(DWScheduleQuartzInfo quartzInfo) {
        Boolean result = false;
        try {
            result = this.scheduleService.executeJob(quartzInfo.getScheduleId(), quartzInfo.getModuleName(), quartzInfo.getJobName(), quartzInfo.getContactList(), quartzInfo.getScheduleParam());
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public Object executeSchedule(String scheduleId, String jobName) {
        Boolean result = false;
        try {
            result = this.scheduleService.executeSchedule(scheduleId, jobName);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object addSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        Boolean result = true;
        DWDataSet dataSet = new DWDataSet();
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleDataSet(dataSet, quartzInfo, "C");
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleTimeDataSet(dataSet, quartzInfo, "C");
        List<ScheduleContactDO> contactList = quartzInfo.getContactList();
        dataSet = DWScheduleCastUtils.convertScheduleContactDOListToDataSet(dataSet, contactList, "C");
        String enableStatus = quartzInfo.getEnableStatus();
        this.scheduleDBService.updateScheduleByDataSet(dataSet);
        switch (Integer.parseInt(quartzInfo.getScheduleType())) {
            case 1: {
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                }
                break;
            }
            case 2: {
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addSchedulePeriodically(quartzInfo);
                }
                break;
            }
            case 3: {
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                }
                break;
            }
            case 4: {
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                }
                break;
            }
            default: {
                result = false;
                break;
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object updateSchedule(DWScheduleQuartzInfo quartzInfo) throws Exception {
        Boolean result = true;
        DWDataSet dataSet = new DWDataSet();
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleDataSet(dataSet, quartzInfo, "U");
        dataSet = DWScheduleCastUtils.convertScheduleQuartzInfoToScheduleTimeDataSet(dataSet, quartzInfo, "U");
        List<ScheduleContactDO> contactList = quartzInfo.getContactList();
        dataSet = DWScheduleCastUtils.convertScheduleContactDOListToDataSet(dataSet, contactList, "U");
        String enableStatus = quartzInfo.getEnableStatus();
        this.scheduleDBService.updateScheduleByDataSet(dataSet);
        switch (Integer.parseInt(quartzInfo.getScheduleType())) {
            case 1: {
                this.scheduleService.removeSchedule(quartzInfo);
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                }
                break;
            }
            case 2: {
                this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addSchedulePeriodically(quartzInfo);
                }
                break;
            }
            case 3: {
                this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                }
                break;
            }
            case 4: {
                this.scheduleService.deleteJob(quartzInfo.getScheduleId());
                if (enableStatus.equals("Y")) {
                    this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                }
                break;
            }
            default: {
                result = false;
                break;
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object deleteSchedule(List<String> scheduleIdList) throws Exception {
        Boolean result = true;
        for (String scheduleId : scheduleIdList) {
            this.scheduleService.deleteJob(scheduleId);
            this.scheduleDBService.deleteSchedule(scheduleId);
            this.scheduleTimeDBService.deleteScheduleTime(scheduleId);
            this.scheduleContactDBService.deleteScheduleContact(scheduleId);
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public Object setScheduleStatus(String status, List<String> scheduleIdList) throws Exception {
        Boolean result = null;
        if ("Y".equals(status)) {
            block10: for (String scheduleId : scheduleIdList) {
                DWDataRow scheduleDataSet = this.scheduleDBService.getScheduleInfo(scheduleId);
                DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertDataRowToScheduleQuartzInfo(scheduleDataSet);
                DWDataRow scheduleTimeDataSet = this.scheduleTimeDBService.getScheduleTimeInfo(scheduleId);
                ScheduleTimeDO timeDo = DWScheduleCastUtils.convertDataRowToScheduleTimeDo(scheduleTimeDataSet);
                quartzInfo.setDetail(timeDo);
                List queryContact = (List)this.scheduleContactDBService.queryScheduleContactList(scheduleId);
                List<ScheduleContactDO> contactList = DWScheduleCastUtils.convertToScheduleContactList(queryContact);
                quartzInfo.setContactList(contactList);
                this.scheduleDBService.enableSchedule(scheduleId);
                switch (Integer.parseInt(quartzInfo.getScheduleType())) {
                    case 1: {
                        this.scheduleService.addScheduleRunAtSpecificTime(quartzInfo);
                        continue block10;
                    }
                    case 2: {
                        this.scheduleService.addSchedulePeriodically(quartzInfo);
                        continue block10;
                    }
                    case 3: {
                        this.scheduleService.addScheduleJobByCalendarInterval(quartzInfo);
                        continue block10;
                    }
                    case 4: {
                        this.scheduleService.addScheduleJobByRecurrenceRule(quartzInfo);
                        continue block10;
                    }
                }
                result = false;
            }
        } else {
            for (String scheduleId : scheduleIdList) {
                this.scheduleDBService.disableSchedule(scheduleId);
                this.scheduleService.deleteJob(scheduleId);
            }
        }
        return result;
    }

    public Object getScheduleInfo(String scheduleId) throws Exception {
        return this.scheduleDBService.getScheduleInfo(scheduleId);
    }

    public Object getScheduleTimeInfo(String scheduleId) throws Exception {
        return this.scheduleTimeDBService.getScheduleTimeInfo(scheduleId);
    }

    public Object getScheduleList(DWPagableQueryInfo param) throws Exception {
        return this.scheduleDBService.getScheduleList(param);
    }

    public Object getScheduleRecordList(DWPagableQueryInfo param) throws Exception {
        return this.scheduleRecordDBService.getResultList(param);
    }

    public Object getScheduleRecordInfo(DWPagableQueryInfo param) throws Exception {
        return this.scheduleRecordDBService.getResult(param);
    }

    public Object getAvailableJobList() throws Exception {
        return this.jobService.getAvailableJobList();
    }
}

