/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.entity;

import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.entity.InternalTime;
import com.digiwin.app.schedule.entity.SingleTime;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DWScheduleQuartzInfo
implements Serializable {
    private static final long serialVersionUID = 5594201773642571323L;
    private Integer id;
    private String scheduleId;
    private String scheduleName;
    private String scheduleType;
    private String jobName;
    private String enableStatus;
    private String description;
    private Date effectiveTime;
    private Date expireTime;
    private String maxRuntime;
    private String recentStatus;
    private Date lastSuccessTime;
    private Date lastPeriodTime;
    private Date nextExecuteTime;
    private String moduleName;
    private String rrule;
    private ScheduleTimeDO detail;
    private List<ScheduleContactDO> contactList;
    private List<String> expList = new ArrayList<String>();
    private SingleTime singleTime;
    private List<InternalTime> internalTimeList = new ArrayList<InternalTime>();
    private Map<String, Object> scheduleParam;
    private String execJobUserId;
    private Long tenantSid;

    public String getDayRadio() {
        boolean day = false;
        boolean week = false;
        if (this.detail != null && this.detail.getDayOfMonth() != null && this.detail.getDayOfMonth().length() > 0) {
            day = true;
        }
        if (this.detail != null && this.detail.getWeek() != null && this.detail.getWeek().length() > 0) {
            week = true;
        }
        if (day && week) {
            return "2";
        }
        if (!day && week) {
            return "0";
        }
        if (day && !week) {
            return "1";
        }
        return "3";
    }

    public String getMonthRadio() {
        if (this.detail != null && this.detail.getMonth() != null && this.detail.getMonth().length() > 0) {
            return "1";
        }
        return "0";
    }

    public String getTimeRadio() {
        if (this.singleTime != null) {
            return "0";
        }
        return "1";
    }

    public String getWeekRadio() {
        if (this.detail != null && this.detail.getWeekOfMonth() != null && this.detail.getWeekOfMonth().length() > 0) {
            return "1";
        }
        return "0";
    }

    public String getHolidayCheck() {
        if (this.detail != null && this.detail.getHoliday() != null && this.detail.getHoliday().length() > 0) {
            return "Y";
        }
        return "N";
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getEnableStatus() {
        return this.enableStatus;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getMaxRuntime() {
        return this.maxRuntime;
    }

    public void setMaxRuntime(Object maxRuntime) {
        if (maxRuntime instanceof Integer) {
            this.maxRuntime = ((Integer)maxRuntime).toString();
            return;
        }
        this.maxRuntime = (String)maxRuntime;
    }

    public Map<String, Object> getScheduleParam() {
        return this.scheduleParam;
    }

    public void setScheduleParam(Map<String, Object> scheduleParam) {
        this.scheduleParam = scheduleParam;
    }

    public ScheduleTimeDO getDetail() {
        return this.detail;
    }

    public void setDetail(ScheduleTimeDO detail) {
        String month = this.checkHasItem(detail.getMonth());
        if (detail.getTime() != null && detail.getTime().length() > 0) {
            this.singleTime = new SingleTime();
            String[] timeArray = detail.getTime().split(",");
            this.singleTime.setHour(timeArray[0]);
            this.singleTime.setMinute(timeArray[1]);
            this.singleTime.setSecond(timeArray[2]);
        }
        if (detail.getTime1() != null && detail.getTime1().length() > 0) {
            this.internalTimeList.add(DWScheduleCastUtils.convertStringToInternalTime(detail.getTime1()));
        }
        if (detail.getTime2() != null && detail.getTime2().length() > 0) {
            this.internalTimeList.add(DWScheduleCastUtils.convertStringToInternalTime(detail.getTime2()));
        }
        if (detail.getTime3() != null && detail.getTime3().length() > 0) {
            this.internalTimeList.add(DWScheduleCastUtils.convertStringToInternalTime(detail.getTime3()));
        }
        if (detail.getWeekOfMonth() != null && detail.getWeekOfMonth().length() > 0) {
            if (detail.getWeek() != null && detail.getWeek().length() > 0) {
                String[] weekOfMonthArray = detail.getWeekOfMonth().split(",");
                String[] week = detail.getWeek().split(",");
                for (int i = 0; i < weekOfMonthArray.length; ++i) {
                    for (int j = 0; j < week.length; ++j) {
                        this.expList.add(this.generateCronExpression("?", month, week[j] + "#" + weekOfMonthArray[i]));
                    }
                }
            }
        } else if (detail.getWeek() != null && detail.getWeek().length() > 0) {
            this.expList.add(this.generateCronExpression("?", month, detail.getWeek()));
        }
        if (detail.getDayOfMonth() != null && detail.getDayOfMonth().length() > 0) {
            if (detail.getDayOfMonth().contains("L")) {
                String dayOfMonth = detail.getDayOfMonth();
                String[] days = dayOfMonth.split(",");
                if (days.length > 1) {
                    dayOfMonth = dayOfMonth.replace(",L", "").replace("L,", "");
                    this.expList.add(this.generateCronExpression(dayOfMonth, month, "?"));
                }
                this.expList.add(this.generateCronExpression("L", month, "?"));
            } else {
                this.expList.add(this.generateCronExpression(detail.getDayOfMonth(), month, "?"));
            }
        }
        if (this.expList.size() == 0) {
            this.expList.add(this.generateCronExpression("*", month, "?"));
        }
        this.detail = detail;
    }

    public List<ScheduleContactDO> getContactList() {
        return this.contactList;
    }

    public void setContactList(List<ScheduleContactDO> contactList) {
        this.contactList = contactList;
    }

    public List<String> getExpList() {
        return this.expList;
    }

    public void setExpList(List<String> expList) {
        this.expList = expList;
    }

    public SingleTime getSingleTime() {
        return this.singleTime;
    }

    public void setSingleTime(SingleTime singleTime) {
        this.singleTime = singleTime;
    }

    public List<InternalTime> getInternalTimeList() {
        return this.internalTimeList;
    }

    public void setInternalTimeList(List<InternalTime> internalTimeList) {
        this.internalTimeList = internalTimeList;
    }

    public String getRecentStatus() {
        return this.recentStatus;
    }

    public void setRecentStatus(String recentStatus) {
        this.recentStatus = recentStatus;
    }

    public Date getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public void setLastSuccessTime(Date lastSuccessTime) {
        this.lastSuccessTime = lastSuccessTime;
    }

    public Date getLastPeriodTime() {
        return this.lastPeriodTime;
    }

    public void setLastPeriodTime(Date lastPeriodTime) {
        this.lastPeriodTime = lastPeriodTime;
    }

    public Date getNextExecuteTime() {
        return this.nextExecuteTime;
    }

    public void setNextExecuteTime(Date nextExecuteTime) {
        this.nextExecuteTime = nextExecuteTime;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    private String checkHasItem(String item) {
        if (item != null && item.length() > 0) {
            return item;
        }
        return "*";
    }

    private String generateCronExpression(String dayOfMonth, String month, String dayOfWeek) {
        return String.format("%1$s %2$s %3$s", dayOfMonth, month, dayOfWeek);
    }

    public String getExecJobUserId() {
        return this.execJobUserId;
    }

    public void setExecJobUserId(String execJobUserId) {
        this.execJobUserId = execJobUserId;
    }

    public Long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(Long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getRrule() {
        return this.rrule;
    }

    public void setRrule(String rrule) {
        this.rrule = rrule;
    }
}

