/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.service.DWServiceContext;
import com.google.gson.Gson;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class DWQuartzJobListener
implements JobListener {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartzJobListener]";
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String JOB_LISTENER_NAME = "DWQuartzJobListener";
    private DWScheduleRecordDBService recordService = DWScheduleRecordDBService.getInstance();
    private DWScheduleDBService scheduleDBService = DWScheduleDBService.getInstance();
    private static boolean tenantEnabled = new Boolean(System.getProperty("server.tenant"));
    private static String tenantColumnName = System.getProperty("server.tenant.columnname");
    private static String IAM_TENANTSID = "tenantSid";
    private static String IAM_USERID = "userId";
    private static String _SCHEDULEID = "schedule";
    private Gson gson = new Gson();

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String scheduleId = jobDataMap.getString("schedule_id");
        String jobName = jobDataMap.getString("job_name");
        Object scheduleParam = jobDataMap.get((Object)"schedule_param");
        String scheduleType = jobDataMap.getString("schedule_type");
        try {
            Date now = new Date();
            String executeId = jobDataMap.getString("execute_id");
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("$state", (Object)"C");
            recordRow.set("schedule_id", (Object)scheduleId);
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("execute_status", (Object)"running");
            recordRow.set("start_time", (Object)new Timestamp(now.getTime()));
            recordRow.set("schedule_param", (Object)this.gson.toJson(scheduleParam));
            recordRow.set("job_name", (Object)jobName);
            recordRow.set("schedule_type", (Object)scheduleType);
            HashMap<String, Object> profile = new HashMap<String, Object>();
            if (tenantEnabled) {
                recordRow.set(tenantColumnName, jobDataMap.get((Object)tenantColumnName));
                if (jobDataMap.containsKey((Object)tenantColumnName)) {
                    profile.put(IAM_TENANTSID, jobDataMap.get((Object)tenantColumnName));
                } else {
                    this.log.error((Object)String.format("[DWSchedule.DWQuartzJobListener][jobToBeExecuted] %s is missing in jobDataMap", tenantColumnName));
                }
                if (jobDataMap.containsKey((Object)"tenantId")) {
                    profile.put("tenantId", jobDataMap.get((Object)"tenantId"));
                }
                if (jobDataMap.containsKey((Object)"dw_schedule_exec_userid") && jobDataMap.get((Object)"dw_schedule_exec_userid") != null) {
                    profile.put(IAM_USERID, jobDataMap.get((Object)"dw_schedule_exec_userid"));
                }
            } else {
                profile.put(IAM_USERID, _SCHEDULEID);
            }
            DWServiceContext.getContext().setProfile(profile);
            this.recordService.updateByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String exeStatus = jobDataMap.getString("execute_status");
        if (exeStatus == null) {
            exeStatus = "completed";
        }
        String executeId = jobDataMap.getString("execute_id");
        String scheduleId = jobDataMap.getString("schedule_id");
        Object message = jobDataMap.get((Object)"message");
        Object messageDetail = jobDataMap.get((Object)"message_detail");
        Date now = new Date();
        try {
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("$state", (Object)"U");
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("execute_status", (Object)exeStatus);
            recordRow.set("end_time", (Object)new Timestamp(now.getTime()));
            recordRow.set("message", message);
            recordRow.set("message_detail", messageDetail);
            DWDataRow scheduleRow = dataSet.newTable("dw_schedule").newRow();
            Date nextTime = context.getNextFireTime();
            scheduleRow.set("schedule_id", (Object)scheduleId);
            scheduleRow.set("recent_status", (Object)exeStatus);
            scheduleRow.set("next_execute_time", (Object)new Timestamp(nextTime.getTime()));
            scheduleRow.set("$state", (Object)"U");
            if (exeStatus.equals("completed")) {
                long periodTime = context.getJobRunTime();
                scheduleRow.set("last_success_time", (Object)new Timestamp(now.getTime()));
                scheduleRow.set("last_period_time", (Object)periodTime);
            }
            this.scheduleDBService.updateScheduleByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String scheduleId = jobDataMap.getString("schedule_id");
        String jobName = jobDataMap.getString("job_name");
        Object scheduleParam = jobDataMap.get((Object)"schedule_param");
        try {
            Date now = new Date();
            String executeId = jobDataMap.get((Object)"execute_id").toString();
            DWDataSet dataSet = new DWDataSet();
            DWDataRow recordRow = dataSet.newTable("dw_schedule_record").newRow();
            recordRow.set("execute_id", (Object)executeId);
            recordRow.set("schedule_id", (Object)scheduleId);
            recordRow.set("job_name", (Object)jobName);
            recordRow.set("execute_status", (Object)"skipped");
            recordRow.set("start_time", (Object)new Timestamp(now.getTime()));
            recordRow.set("schedule_param", scheduleParam);
            DWDataRow row = dataSet.newTable("dw_schedule").newRow();
            row.set("recent_status", (Object)"skipped");
            row.set("schedule_id", (Object)scheduleId);
            row.set("$state", (Object)"U");
            this.recordService.updateByDataSet(dataSet);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(this.log, CLASS_TAG, e);
        }
    }
}

