/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.service;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.service.DWServiceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobKey;

public class DWJobService {
    private DWQuartz quartz = DWQuartz.getInstance();
    private static DWJobService instance = null;
    private List<String> jobList = null;
    private static final String JOB_INTERFACE = "com.digiwin.app.schedule.quartz.job.DWJob";
    private static boolean tenantEnabled = new Boolean(System.getProperty("server.tenant"));
    private static String tenantColumnName = System.getProperty("server.tenant.columnname");
    private static String IAM_TENANTSID = "tenantSid";
    private static String IAM_USERID = "userId";

    public static DWJobService getInstance() {
        if (instance == null) {
            instance = new DWJobService();
        }
        return instance;
    }

    public Object getAvailableJobList() throws Exception {
        if (this.jobList != null) {
            return this.jobList;
        }
        this.jobList = new ArrayList<String>();
        DWHeaderRepository repository = (DWHeaderRepository)SpringContextUtils.getBean((String)"DWHeaderRepository");
        List headers = repository.getAllHeader();
        for (DWHeader header : headers) {
            if (!this.isJobHeader(header)) continue;
            this.jobList.add(header.getServiceName());
        }
        return this.jobList;
    }

    private boolean isJobHeader(DWHeader header) {
        Class jobServiceClass;
        boolean result = false;
        String moduleName = header.getModuleName();
        Class serviceType = header.getServiceType();
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName((String)moduleName);
        if (classLoader == null) {
            return result;
        }
        try {
            jobServiceClass = classLoader.loadClass(JOB_INTERFACE);
        }
        catch (ClassNotFoundException e) {
            return result;
        }
        if (jobServiceClass.isAssignableFrom(serviceType)) {
            result = true;
        }
        return result;
    }

    public void executeJob(String jobName, String gruop) {
        JobKey jobkey = JobKey.jobKey((String)jobName, (String)gruop);
        this.quartz.triggerJob(jobkey);
    }

    public JobDataMap getJobDataMap(DWScheduleQuartzInfo quartzInfo) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("schedule_id", quartzInfo.getScheduleId());
        jobDataMap.put("job_name", quartzInfo.getJobName());
        jobDataMap.put("max_runtime", quartzInfo.getMaxRuntime());
        jobDataMap.put("schedule_param", quartzInfo.getScheduleParam());
        jobDataMap.put("schedule_type", quartzInfo.getScheduleType());
        jobDataMap.put("enable_status", quartzInfo.getEnableStatus());
        jobDataMap.put("contact_list", quartzInfo.getContactList());
        jobDataMap.put("module_name", quartzInfo.getModuleName());
        if (tenantEnabled) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile != null && profile.size() > 0) {
                if (!profile.containsKey(IAM_TENANTSID)) {
                    throw new DWDataException(String.format("[DWSchedule]DWJobService.getJobDataMap: %s is missing in profile", IAM_TENANTSID));
                }
                Long tenantSid = (Long)profile.get(IAM_TENANTSID);
                jobDataMap.put(tenantColumnName, (Object)tenantSid);
                if (profile.containsKey("tenantId")) {
                    String tenantId = String.valueOf(profile.get("tenantId"));
                    jobDataMap.put("tenantId", tenantId);
                }
                if (profile.containsKey(IAM_USERID)) {
                    String userId = (String)profile.get(IAM_USERID);
                    jobDataMap.put("dw_schedule_exec_userid", userId);
                }
            } else {
                throw new DWDataException(String.format("[DWSchedule]DWJobService.getJobDataMap: profile is null or empty in multi-tenancy env.", new Object[0]));
            }
        }
        return jobDataMap;
    }
}

