var app = angular.module('app');
app.controller('SettingController', 
		function($scope,           $http,         $mdDialog, 
				 DWMessage,        DWService,     settingService, 
				 parameterStorage, DWSaveService, configService,
				 testcenterClientService) {

	$scope.serverType = testcenterClientService.getServerType();
	
	$scope.setting = {};
	$scope.setting.defaultIpPort = null; // UI 綁定時的第一個 IP & Port
	$scope.setting.otherIpPorts = [];  // UI 綁定時第二個之後的 IP & Port List
	$scope.basicUrl; 
	$scope.moduleListServiceUrl; 
	$scope.tokenServiceUrl;
	$scope.tokenServiceParameter;
	
	// 單元測試
	$scope.setting.unitTest = {};
	$scope.setting.unitTest.userId = null;
	$scope.setting.unitTest.rapIpPort = null;
	$scope.setting.unitTest.rapProjectId = null;
	
	// JSON Viewer
	$scope.setting.jsonviewer = {};
	$scope.setting.jsonviewer.type = 0;
	
	// 2018-11-6 falcon 增加選取設定
	$scope.settingNames = [];
	$scope.selectedSettingName = settingService.initSettingName;
	
	$scope.saveSetting = function() {

		if (this.selectedSettingName != settingService.defaultSettingName) {
			var confirm = $mdDialog
		   	  .confirm()
		   	  .title('保存目標確認')
		   	  .textContent('選取的設定尚未套用載入, 你確定要將頁面上的設定保存至  [ ' + this.selectedSettingName + '] ?')
		   	  //.targetEvent(ev)
		   	  .ok('確定')
		   	  .cancel('取消');
	
			$mdDialog.show(confirm).then(
				function() {
					
					this.saveSettingCore();
				}, 
				function() {
					
					DWMessage.showInfo("取消保存!");
				}
			);
		}
		else {

			this.saveSettingCore();
		}
	}
	
	$scope.saveSettingCore = function() {
		
		var standardSetting = this.getStandardSettingFromController();

		// 2018-11-12 改為保存至選取的設定文件上 this.selectedSettingName
		DWSaveService.putData('setting', this.selectedSettingName, standardSetting)
		.then(function successCallback(response) {

			settingService.setSetting(standardSetting);

			DWMessage.showInfo("保存設定完畢.");
		}, function errorCallback(response) {

			DWMessage.showError("保存設定失敗!");
		});
	}
	
	$scope.clearSetting = function() {
		
		this.setting = {};
		this.setting.otherIpPorts = [];  // UI 綁定時第二個之後的 IP & Port List
	}

	$scope.deleteSetting = function() {
		
		DWSaveService.deleteData('setting', 'setting')
		.then(function successCallback(response) {
			
			$scope.setting = {};
			settingService.setSetting($scope.setting);
			DWMessage.showInfo("刪除設定完畢.");
		}, function errorCallback(response) {
			
			DWMessage.showError("刪除設定失敗!");
		});
	}
	
	/**
	 * 加入新的 dwgateway IP 和 Port 設定
	 */
	$scope.addIpPort = function() {
		
		this.setting.otherIpPorts.push("");
	}
	
	/**
	 * 移除 IP 和 Port 設定
	 * @param index 索引值
	 */
	$scope.removeIpPort = function(index) {
		
		if (this.setting.defaultIpPortIndex == index + 1) {
			
			this.setting.defaultIpPortIndex = 0;
		}
		
		// 移除特定索引值項目
		this.setting.otherIpPorts.splice(index, 1);
	}
	
	/**
	 * 刷新模組信息
	 */
	$scope.refreshModuleInfo = function() {
		
		DWService.initDWModuleInfoList(true);
	}
	
	/**
	 * 是否為默認的 IP Port
	 */
	$scope.isDefaultIpPort = function(index) {
		
		if (!this.setting.defaultIpPortIndex) {
			
			return index == 0;
		}

		return this.setting.defaultIpPortIndex == index;
	}
	
	/**
	 * 下載 RAP 專案信息
	 */
	$scope.downloadRapProjectInfo = function() {
		
		var rapIpPort = this.setting.unitTest.rapIpPort;
		var rapProjectId = this.setting.unitTest.rapProjectId;
		
		DWService.invokeRapService(rapIpPort, rapProjectId).then(
			function(response) { //success;

				var alert = $mdDialog.alert()
				.title('RAP 專案: ' + rapProjectId + ' 信息')
				.content(response.data)
				.ok('確定');
		
				$mdDialog.show(alert).finally(
					function() {

						alert = undefined;
					}
				);
			},
			function(response) { //failure
				
				DWMessage.showError("取得 RAP 專案信息失敗!");
			}
		);
	}

	/**
	 * 從 Controller 取得標準保存的 setting
	 */
	$scope.getStandardSettingFromController = function() {
		
		var standardSetting = $.extend(true, {}, this.setting);
		
		// 將 default IP Port insert 到 other IP Port List 中的第一個位置
		standardSetting.otherIpPorts.unshift(this.setting.defaultIpPort);
		standardSetting.dwgatewayIpPorts = standardSetting.otherIpPorts;

		delete standardSetting.defaultIpPort;
		delete standardSetting.otherIpPorts;
		
		return standardSetting;
	}
	
	/**
	 * 設定讀取後監聽者
	 */
	$scope.settingAfterLoadedlistener = function() {

		// 將 標準的設定轉為 UI 的設定
		var standardSetting = settingService.setting;
		var uiSetting = $.extend(true, {}, standardSetting);
		
		var dwgatewayIpPorts;
		if ($.isArray(standardSetting.dwgatewayIpPorts)) {
			
			dwgatewayIpPorts = standardSetting.dwgatewayIpPorts;
		}
		else {
			
			// 格式不符
			dwgatewayIpPorts = [];
		}
		
		// UI 字段 (默認的 IP Port)
		uiSetting.defaultIpPort = dwgatewayIpPorts.length > 0 ? dwgatewayIpPorts[0] : "";

		if (dwgatewayIpPorts.length > 1) {
			
			// UI 字段 (其他的 IP Port 清單)
			uiSetting.otherIpPorts = dwgatewayIpPorts.slice(1, dwgatewayIpPorts.length);
		}
		else {
			
			uiSetting.otherIpPorts = [];
		}
		
		// 刪除 UI 設定上的全部 IP Port 清單
		delete uiSetting.dwgatewayIpPorts;
		
		// standard setting 的 UI 字段
		delete uiSetting.dwgatewayUrls;
		
		// 檢查 defaultIpPortIndex 是否在範圍內
		if (!$.isNumeric(uiSetting.defaultIpPortIndex) || uiSetting.defaultIpPortIndex >= dwgatewayIpPorts.length) {
			
			uiSetting.defaultIpPortIndex = 0;
		}
		
		// 2016-12-3 falcon 這裡一定要用 $scope, 因為此方法是在 settingService 直接調用
		// 所以 this 指的是 window
		$scope.setting = uiSetting;
		
		// 2018-11-6 falcon 取下拉清單
		var controller = $scope;
		DWSaveService.getDataList('setting', false)
		.then(
			function (response) {

				controller.settingNames.length = 0;
				
				var id;
				var list = response.getResult();
				var isDefaultSettingExists = false;
				for (var idx in list) {
					
					id = list[idx].documentId;
					if (id.toLowerCase() == "default") continue;

					controller.settingNames.push(id);
					
					if (id == settingService.defaultSettingName) isDefaultSettingExists = true;
				}
				
				if (!isDefaultSettingExists) controller.settingNames.push(settingService.defaultSettingName);
				$scope.selectedSettingName = settingService.defaultSettingName;
			},
			function (response) {
				
				if (response.status == -1) {
					
					DWMessage.showError("無法連接  DWRequester 服務器!");
				}
			}
		);
	}
	
	$scope.onSelectedSettingNameChanged = function() {
		
		console.log("change current setting(" + settingService.defaultSettingName + ") to setting(" + this.selectedSettingName + ")");
	}
	
	/**
	 * 2018-11-7 falcon 套用設定
	 */
	$scope.applySetting = function() {
		
		// default 文件中是純文字, 不用  format 設定為 0
		DWSaveService.putData('setting', 'default', this.selectedSettingName)
		.then(function successCallback(response) {

			location.reload();
		}, function errorCallback(response) {

			DWMessage.showError("套用設定失敗!");
		});
	}
	
	$scope.$on('$destroy', function(event) {

		settingService.unregisterOnAfterLoadedListener(event.currentScope.settingAfterLoadedlistener);
	});

	// 註冊事件監聽設定加載後事件
	settingService.registerOnAfterLoadedListener($scope.settingAfterLoadedlistener);
	
});