var app = angular.module('app');
app.service('DWSaveService', 
		['DWMessage', 'loginService', 'testcenterClientService', '$http', '$q', 
		 function(DWMessage, loginService, testcenterClientService, $http, $q) {

	// create
	this.postData = function(group, documentId, value) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/"+userid+"/"+group+"/"+documentId;

		var request = {method: 'POST',
					   url: url,
					   headers: {'Content-Type':'text/plain',
						   		 'token':token},
					   data: JSON.stringify(value)};

		return this.sendRequest(request);
	}

	// read
	this.getData = function(group, documentId, queryString) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/"+userid+"/"+group+"/"+documentId;
		
		var urlWithQueryString = url;

		if(queryString) {
			urlWithQueryString += "?" + queryString;
		}
		
		var request = {method: 'GET',
					   headers: {'token':token},
					   url: urlWithQueryString};
		
		return this.sendRequest(request);
    }

	// 2018-11-12 falcon @TODO post 方法需要改為和  put 相同的處理邏輯
	// update
	this.putData = function(group, documentId, value, queryString) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/"+userid+"/"+group+"/"+documentId;

		var urlWithQueryString = url;

		if(queryString) {
			urlWithQueryString += "?" + queryString;
		}
		else if (typeof(value) == "string") {
			
			urlWithQueryString += "?format=0";
		}
		
		var requestData;
		// 2018-11-12 falcon 如果內容是純文字就不用 stringify
		if (typeof(value) == "string") {
			
			requestData = value;
		}
		else {
			
			requestData = JSON.stringify(value);
		}
		
		var request = {method: 'PUT',
					   url: urlWithQueryString,
					   headers: {'Content-Type':'text/plain',
						   		 'token':token},
					   data: requestData };

		return this.sendRequest(request);
    }
	
	// delete
	this.deleteData = function(group, documentId) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/"+userid+"/"+group+"/"+documentId;

		var request = {method: 'DELETE',
					   headers: {'token':token},
					   url: url};

		return this.sendRequest(request);
    }
	
	this.getDataList = function(group, isNormalReturn) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/list/"+userid+"/"+group;
		
		var request = {method: 'GET',
					   headers: {'token':token},
					   url: url};
		
		if(isNormalReturn) {
			return testcenterClientService.apiRequest(request);
		} else {
			return this.sendRequest(request);
		}
    }
	
	this.downloadData = function(group, value) {
		
		var token = loginService.getToken();
		var userid = loginService.getUserId();

		var url = "/testcenter/dwrequester/service/save/download/"+userid+"/"+group+"?filenames="+value;
		
		var request = {method: 'GET',
					   headers: {'token':token},
					   url: url};
		
		return testcenterClientService.apiRequest(request);
    }
	
	/**
	 * 2017-1-10 falcon
	 * 發出請求
	 * @param request 請求
	 */
	this.sendRequest = function (request) {
		
		if (!request || !request.url) return;
		
		var def = $q.defer();

		testcenterClientService.apiRequest(request).then(
			function(response) { // success
				
				var userDataWrapper = new DWUserDataModelWrapper(response);
				def.resolve(userDataWrapper);
			},
			function(response) { // failure
				
				var userDataWrapper = new DWUserDataModelWrapper(response);
				
				if (userDataWrapper.isConnectionError()) {
					
					DWMessage.showError("無法連接  DWRequester 服務器!");
				}
				
				def.reject(userDataWrapper);
			}
		);
		
		return def.promise;
	}
}]);