var app = angular.module('app');
app.service('loginService', 
		['$http', '$cookies', 'testcenterClientService', 
		 function($http, $cookies, testcenterClientService) {

    this.setToken = function(token, expireDate) {
    	$cookies.put('TestCenter.DWRequester.token', token, {'expires': expireDate});
    }
	
    this.getToken = function() {
        return $cookies.get('TestCenter.DWRequester.token');
    }
    
    this.setUserId = function(userId, expireDate) {
    	$cookies.put('TestCenter.DWRequester.userId', userId, {'expires': expireDate});
    }
	
    this.getUserId = function() {
        return $cookies.get('TestCenter.DWRequester.userId');
    }

    this.setUserName = function(username, expireDate) {
    	$cookies.put('TestCenter.DWRequester.username', username, {'expires': expireDate});
    }
	
    this.getUserName = function() {
        return $cookies.get('TestCenter.DWRequester.username');
    }
    
    this.doLogin = function(userid, password) {
    	
    	var authData = b64EncodeUnicode(userid + ':' + password);
    	
		var request = {method: 'GET', 
					   headers: {'Authorization': 'Basic ' + authData},
					   url: '/testcenter/dwrequester/service/login/dologin',
					   data: {'userid': userid, 
						      'password': password}};
		
		return testcenterClientService.apiRequest(request);
    }
    
    this.doLogout = function() {
    	
    	$cookies.remove('TestCenter.DWRequester.token');
    	$cookies.remove('TestCenter.DWRequester.userid');
    	$cookies.remove('TestCenter.DWRequester.username');
    }    
    
    function b64EncodeUnicode(str) {
        return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
            return String.fromCharCode('0x' + p1);
        }));
    }
    
    function b64DecodeUnicode(str) {
        return decodeURIComponent(Array.prototype.map.call(atob(str), function(c) {
            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
        }).join(''));
    }
}]);