#!/bin/bash

gatewaySettingName="./dwLogTool_gateway_setting"
dubboSettingName="./dwLogTool_dubbo_setting"
settingName=""
echo ====================================================
echo Digiwin Test Center - Gateway Log Analyzer Tool Menu
echo ----------------------------------------------------
echo      [1].分析 DWGateway 日誌
echo      [2].分析 DWDubbo 日誌

echo      [其他鍵].結束工具
echo ====================================================
read -p '請輸入欲分析的日誌類型(1 或 2): ' analyzeType


if [ "$analyzeType" == "1" ]; then
  settingName=$gatewaySettingName
elif [ "$analyzeType" == "2" ]; then
  settingName=$dubboSettingName
fi

if [ -n "$settingName" ]; then
  echo ...使用的設定為 $settingName
  read -p '請輸入欲分析的日誌文件名: ' logFileName
  read -p '請輸入欲配置的Xmx(默認為1024m): ' xmxSize
  if [ -z "$xmxSize" ]
  then
  	xmxSize="1024m"
  	echo ...Use default xmxSize is $xmxSize
  else
    echo ..Use custom Xmx Size is $xmxSize
  fi
  
  read -p '指定搜尋開始時間(HH:mm):' searchStartTime
  read -p '........結束時間(HH:mm):' searchEndTime
  read -p '指定服務關鍵字:' searchServiceName
  
  if  [ -n "$searchServiceName" ]; then
     read -p '...是否搜集服務明細(y 表示是):' collectServiceDetails
  fi
  
  java -Xmx$xmxSize -cp ./DWTestCenterProtable.jar com.digiwin.testcenter.dwrequester.analyzer.DWLogToExcel "$settingName" "$logFileName" "$searchStartTime" "$searchEndTime" "$searchServiceName" "$collectServiceDetails"
else
    echo '退出工具...'
fi