/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Log4jImpl
implements Log {
    private static final String callerFQCN = Log4jImpl.class.getName();
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private int debugCount;

    public Log4jImpl(Logger log) {
        this.log = log;
    }

    public Log4jImpl(String loggerName) {
        this.log = Logger.getLogger(loggerName);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void error(String s, Throwable e) {
        ++this.errorCount;
        this.log.log(callerFQCN, Level.ERROR, s, e);
    }

    @Override
    public void error(String s) {
        ++this.errorCount;
        this.log.log(callerFQCN, Level.ERROR, s, null);
    }

    @Override
    public void debug(String s) {
        ++this.debugCount;
        this.log.log(callerFQCN, Level.DEBUG, s, null);
    }

    @Override
    public void debug(String s, Throwable e) {
        ++this.debugCount;
        this.log.log(callerFQCN, Level.DEBUG, s, e);
    }

    @Override
    public void warn(String s) {
        this.log.log(callerFQCN, Level.WARN, s, null);
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.log(callerFQCN, Level.WARN, s, e);
        ++this.warnCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
        this.debugCount = 0;
    }

    @Override
    public int getDebugCount() {
        return this.debugCount;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ++this.infoCount;
        this.log.log(callerFQCN, Level.INFO, msg, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor(Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabledFor(Level.ERROR);
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    public String toString() {
        return this.log.toString();
    }
}

