/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public interface ImpalaUtilConstants {
    public static final String TEST_DEV = "test_dev";
    public static final String PROD_HW = "prod_hw";
    public static final String TEST_HW = "test_hw";
    public static final String PROD_AZURE = "prod_azure";
    public static final String IMPALA = "impala";
    public static final String HIVE = "hive";
    public static final Map<String, String> JDBC_DRIVER_MAP = new HashMap<String, String>(){
        {
            this.put(ImpalaUtilConstants.IMPALA, "com.cloudera.impala.jdbc41.Driver");
            this.put(ImpalaUtilConstants.HIVE, "org.apache.hive.jdbc.HiveDriver");
        }
    };
    public static final Map<String, TypeInfo> hivePrimitiveTypeInfoMap = new HashMap<String, TypeInfo>(){
        {
            this.put("void", TypeInfoFactory.voidTypeInfo);
            this.put("boolean", TypeInfoFactory.booleanTypeInfo);
            this.put("int", TypeInfoFactory.intTypeInfo);
            this.put("long", TypeInfoFactory.longTypeInfo);
            this.put("string", TypeInfoFactory.stringTypeInfo);
            this.put("char", TypeInfoFactory.charTypeInfo);
            this.put("varchar", TypeInfoFactory.varcharTypeInfo);
            this.put("float", TypeInfoFactory.floatTypeInfo);
            this.put("double", TypeInfoFactory.doubleTypeInfo);
            this.put("byte", TypeInfoFactory.byteTypeInfo);
            this.put("short", TypeInfoFactory.shortTypeInfo);
            this.put("date", TypeInfoFactory.dateTypeInfo);
            this.put("timestamp", TypeInfoFactory.timestampTypeInfo);
            this.put("binary", TypeInfoFactory.binaryTypeInfo);
        }
    };
    public static final Map<String, String> webHDFSConf = new HashMap<String, String>(){
        {
            this.put(ImpalaUtilConstants.TEST_DEV, "webhdfs://172.16.2.204:14000");
            this.put(ImpalaUtilConstants.PROD_AZURE, "webhdfs://az-ddp-httpfs.digiwincloudlocal.com:14001");
            this.put(ImpalaUtilConstants.TEST_HW, "webhdfs://hw-test-ddp-httpfs.digiwincloud.com.cn:14001");
            this.put(ImpalaUtilConstants.PROD_HW, "webhdfs://hw-ddp-httpfs.digiwincloud.com.cn:14001");
        }
    };
}

