/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetDataSchema {
    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        MessageType schema = new MessageType("hive_schema", ParquetDataSchema.convertTypes(columnNames, columnTypes));
        return schema;
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalStateException("Mismatched Hive columns and types. Hive columns names found : " + columnNames + " . And Hive types found : " + columnTypes);
        }
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = ParquetDataSchema.convertType(columnNames.get(i), columnTypes.get(i));
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo) {
        return ParquetDataSchema.convertType(name, typeInfo, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Type.Repetition repetition) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                int prec = decimalTypeInfo.precision();
                int scale = decimalTypeInfo.scale();
                int bytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes)).as(OriginalType.DECIMAL)).scale(scale)).precision(prec)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
            }
            if (typeInfo.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return ParquetDataSchema.convertArrayType(name, (ListTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return ParquetDataSchema.convertStructType(name, (StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return ParquetDataSchema.convertMapType(name, (MapTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + typeInfo);
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        return new GroupType(Type.Repetition.OPTIONAL, name, OriginalType.LIST, new Type[]{new GroupType(Type.Repetition.REPEATED, ParquetHiveSerDe.ARRAY.toString(), new Type[]{ParquetDataSchema.convertType("array_element", subType)})});
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo) {
        ArrayList columnNames = typeInfo.getAllStructFieldNames();
        ArrayList columnTypes = typeInfo.getAllStructFieldTypeInfos();
        return new GroupType(Type.Repetition.OPTIONAL, name, ParquetDataSchema.convertTypes(columnNames, columnTypes));
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo) {
        Type keyType = ParquetDataSchema.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), Type.Repetition.REQUIRED);
        Type valueType = ParquetDataSchema.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo());
        return ConversionPatterns.mapType((Type.Repetition)Type.Repetition.OPTIONAL, (String)name, (Type)keyType, (Type)valueType);
    }
}

