/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.parquet;

import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.api.Binary;

public class ParquetDataWrite {
    public static Boolean booleanDataWriter(Boolean val2) {
        return val2;
    }

    public static Integer byteDataWriter(byte val2) {
        return new Integer(val2);
    }

    public static Integer shortDataWriter(Short val2) {
        return new Integer(val2.shortValue());
    }

    public static Integer intWriter(Integer val2) {
        return val2;
    }

    public static Long longWriter(Long val2) {
        return val2;
    }

    public static Float floatWriter(Float val2) {
        return val2;
    }

    public static Double doubleDataWriter(Double val2) {
        return val2;
    }

    public static Binary stringWriter(String val2) {
        return Binary.fromString((String)val2);
    }

    public static Binary varcharWriter(String val2) {
        return Binary.fromString((String)val2);
    }

    public static Binary binaryWrite(byte[] bytes) {
        return Binary.fromByteArray((byte[])bytes);
    }

    public static Binary timestampWrite(Timestamp ts) {
        return NanoTimeUtils.getNanoTime((Timestamp)ts, (boolean)true).toBinary();
    }

    public static Binary decimalWrite(String val2, int prec, int scale) {
        int precToBytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
        HiveDecimal hiveDecimal = HiveDecimal.create((String)val2);
        byte[] decimalBytes = hiveDecimal.bigIntegerBytesScaled(scale);
        if (precToBytes == decimalBytes.length) {
            return Binary.fromByteArray((byte[])decimalBytes);
        }
        byte[] tgt = new byte[precToBytes];
        if (hiveDecimal.signum() == -1) {
            int i = 0;
            while (i < precToBytes) {
                int n = i++;
                tgt[n] = (byte)(tgt[n] | 0xFF);
            }
        }
        System.arraycopy(decimalBytes, 0, tgt, precToBytes - decimalBytes.length, decimalBytes.length);
        return Binary.fromByteArray((byte[])tgt);
    }

    public static Integer dateWrite(Date date) {
        return DateWritable.dateToDays((Date)date);
    }

    public static Group listWrite(Group group, int index, List<String> values) {
        Group listGroup = group.addGroup(index);
        for (String v : values) {
            Group bagGroup = listGroup.addGroup(0);
            bagGroup.add(0, v);
        }
        return group;
    }

    public static Group mapWrite(Group group, int index, Map<String, String> values) {
        Group mapGroup = group.addGroup(index);
        for (String key : values.keySet()) {
            String value = values.get(key);
            Group dataGroup = mapGroup.addGroup(0);
            dataGroup.add("key", key);
            dataGroup.add("value", value);
        }
        return group;
    }

    public static Group structWrite(Group group, int index, String[] values) {
        Group structGroup = group.addGroup(index);
        for (int i = 0; i < values.length; ++i) {
            structGroup.add(i, values[i]);
        }
        return group;
    }
}

