/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateTimeUtil {
    public static final Log logger = LogFactory.getLog(DateTimeUtil.class);
    public static final String DefaultFormatterPattern = "yyyy-MM-dd HH:mm:ss";
    public static final String FormatterPattern_US = "MM/dd/yyyy HH:mm:ss a";
    public static final List<String> PATTERNS = new ArrayList<String>(){
        {
            this.add(DateTimeUtil.DefaultFormatterPattern);
            this.add("yyyy-MM-dd HH:mm");
            this.add("yyyy-MM-dd HH");
            this.add("yyyy-MM-dd");
            this.add("yyyyMMddHHmmss");
            this.add("yyyyMMddHHmm");
            this.add("yyyyMMddHH");
            this.add("yyyyMMdd");
            this.add("yyyyMM");
            this.add("yyyy-MM");
            this.add("yyyy/MM/dd HH:mm:ss");
            this.add("yyyy/MM/dd HH:mm");
            this.add("yyyy/MM/dd HH");
            this.add("yyyy/MM/dd");
            this.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            this.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206");
            this.add("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6");
            this.add("yyyy\u5e74MM\u6708dd\u65e5");
            this.add("yyyy\u5e74MM\u6708");
            this.add("yyyy\u5e74");
            this.add(DateTimeUtil.FormatterPattern_US);
            this.add("MM/dd/yyyy HH:mm:ss");
            this.add("MM/dd/yyyy HH:mm");
            this.add("MM/dd/yyyy HH");
            this.add("MM/dd/yyyy");
            this.add("MMddyyyyHHmmss");
            this.add("MMddyyyyHHmm");
            this.add("MMddyyyyHH");
            this.add("MMddyyyy");
            this.add("yyyy-M-dd HH:mm:ss");
            this.add("yyyy-M-dd HH:mm");
            this.add("yyyy-M-dd HH");
            this.add("yyyy-M-dd");
            this.add("yyyyMddHHmmss");
            this.add("yyyyMddHHmm");
            this.add("yyyyMddHH");
            this.add("yyyyMdd");
            this.add("yyyyM");
            this.add("yyyy-M");
            this.add("yyyy/M/dd HH:mm:ss");
            this.add("yyyy/M/dd HH:mm");
            this.add("yyyy/M/dd HH");
            this.add("yyyy/M/dd");
            this.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            this.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6mm\u5206");
            this.add("yyyy\u5e74M\u6708dd\u65e5HH\u65f6");
            this.add("yyyy\u5e74M\u6708dd\u65e5");
            this.add("yyyy\u5e74M\u6708");
            this.add("yyyy\u5e74");
            this.add("M/dd/yyyy HH:mm:ss a");
            this.add("M/dd/yyyy HH:mm:ss");
            this.add("M/dd/yyyy HH:mm");
            this.add("M/dd/yyyy HH");
            this.add("M/dd/yyyy");
            this.add("MddyyyyHHmmss");
            this.add("MddyyyyHHmm");
            this.add("MddyyyyHH");
            this.add("Mddyyyy");
            this.add("yyyy-M-d HH:mm:ss");
            this.add("yyyy-M-d HH:mm");
            this.add("yyyy-M-d HH");
            this.add("yyyy-M-d");
            this.add("yyyyMdHHmmss");
            this.add("yyyyMdHHmm");
            this.add("yyyyMdHH");
            this.add("yyyyMd");
            this.add("yyyyM");
            this.add("yyyy-M");
            this.add("yyyy/M/d HH:mm:ss");
            this.add("yyyy/M/d HH:mm");
            this.add("yyyy/M/d HH");
            this.add("yyyy/M/d");
            this.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6mm\u5206ss\u79d2");
            this.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6mm\u5206");
            this.add("yyyy\u5e74M\u6708d\u65e5HH\u65f6");
            this.add("yyyy\u5e74M\u6708d\u65e5");
            this.add("yyyy\u5e74M\u6708");
            this.add("yyyy\u5e74");
            this.add("M/d/yyyy HH:mm:ss a");
            this.add("M/d/yyyy HH:mm:ss");
            this.add("M/d/yyyy HH:mm");
            this.add("M/d/yyyy HH");
            this.add("M/d/yyyy");
            this.add("MdyyyyHHmmss");
            this.add("MdyyyyHHmm");
            this.add("MdyyyyHH");
            this.add("Mdyyyy");
            this.add("yyyy-MM-d HH:mm:ss");
            this.add("yyyy-MM-d HH:mm");
            this.add("yyyy-MM-d HH");
            this.add("yyyy-MM-d");
            this.add("yyyyMMdHHmmss");
            this.add("yyyyMMdHHmm");
            this.add("yyyyMMdHH");
            this.add("yyyyMMd");
            this.add("yyyyMM");
            this.add("yyyy-MM");
            this.add("yyyy/MM/d HH:mm:ss");
            this.add("yyyy/MM/d HH:mm");
            this.add("yyyy/MM/d HH");
            this.add("yyyy/MM/d");
            this.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6mm\u5206ss\u79d2");
            this.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6mm\u5206");
            this.add("yyyy\u5e74MM\u6708d\u65e5HH\u65f6");
            this.add("yyyy\u5e74MM\u6708d\u65e5");
            this.add("yyyy\u5e74MM\u6708");
            this.add("yyyy\u5e74");
            this.add("MM/d/yyyy HH:mm:ss a");
            this.add("MM/d/yyyy HH:mm:ss");
            this.add("MM/d/yyyy HH:mm");
            this.add("MM/d/yyyy HH");
            this.add("MM/d/yyyy");
            this.add("MMdyyyyHHmmss");
            this.add("MMdyyyyHHmm");
            this.add("MMdyyyyHH");
            this.add("MMdyyyy");
        }
    };
    public static final DateTimeFormatter DefaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat Formatter_US = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a", Locale.US);
    public static final LocalDateTime DefaultDate = LocalDateTime.of(1970, 1, 1, 0, 0);

    public static double getUnixEpoch(LocalDateTime dateTime) {
        return dateTime.toEpochSecond(ZoneOffset.ofHours(0)) * 1000L;
    }

    public static int dayDiffer(Date startDate, Date endDate) {
        long day = endDate.getTime() - startDate.getTime();
        return (int)(day / 86400000L);
    }

    public static int dayDiffer(LocalDate startDate, LocalDate endDate) {
        long day = endDate.toEpochDay() - startDate.toEpochDay();
        return (int)(day / 86400000L);
    }

    public static Date formatDateStr(String DateStr) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        if (DateStr.length() == 6) {
            df = new SimpleDateFormat("yyMMdd");
        } else if (DateStr.length() == 10) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        } else if (DateStr.length() == 17) {
            df = new SimpleDateFormat("yyyy/MM/dd HHmmss");
        } else if (DateStr.length() == 19) {
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return df.parse(DateStr);
    }

    public static String format(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DefaultFormatterPattern);
        return df.format(date);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date parse(String dateStr, String pattern) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        dateStr = dateStr.replaceAll("[a-zA-Z]", " ").trim();
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DefaultFormatterPattern;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(dateStr);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public static String formatter(Date date, String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = DefaultFormatterPattern;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.format(date);
        }
        catch (Exception var4) {
            return null;
        }
    }

    public static String getDateFormatterPattern(String dateStr) {
        SimpleDateFormat df = null;
        dateStr = dateStr.replaceAll("[a-zA-Z]", " ").trim();
        String realPattern = null;
        for (String pattern : PATTERNS) {
            try {
                df = new SimpleDateFormat(pattern);
                Date date = df.parse(dateStr);
                if (dateStr == null || !dateStr.equals(df.format(date))) continue;
                realPattern = pattern;
                break;
            }
            catch (Exception exception) {
            }
        }
        return realPattern;
    }

    public static String getDateFormatterPattern(Date date) {
        SimpleDateFormat df = null;
        String realPattern = null;
        for (String pattern : PATTERNS) {
            try {
                df = new SimpleDateFormat(pattern);
                String dateStr = df.format(date);
                if (!StringUtils.isNotBlank((CharSequence)dateStr)) continue;
                realPattern = pattern;
                break;
            }
            catch (Exception exception) {
            }
        }
        return realPattern;
    }
}

