/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.utils;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.digiwin.dmp.constant.ImpalaUtilConstants;
import com.digiwin.dmp.model.DataBase;
import com.digiwin.dmp.utils.ImpalaJdbcUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DruidConnectionPoolUtil {
    private static final Logger logger = LogManager.getLogger(DruidConnectionPoolUtil.class);
    private static DruidDataSource druidHADataSource;
    private static Map<String, DruidDataSource> dataSourceMap;
    private static final Object LOCK;
    private static final Object HA_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(DataBase dataBase) throws Exception {
        String CONNECTION_URL = ImpalaJdbcUtil.getImpalaJdbcUrl(dataBase.getEnv(), dataBase.getType(), dataBase.getDatabase(), dataBase.getLable());
        DruidDataSource druidDataSource = dataSourceMap.get(CONNECTION_URL);
        if (null != druidDataSource && !druidDataSource.isClosed()) {
            return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
        }
        Object object = LOCK;
        synchronized (object) {
            druidDataSource = dataSourceMap.get(CONNECTION_URL);
            if (null != druidDataSource && !druidDataSource.isClosed()) {
                return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
            }
            druidDataSource = DruidConnectionPoolUtil.druidConnectionPoolInit(CONNECTION_URL, dataBase);
            dataSourceMap.put(CONNECTION_URL, druidDataSource);
            return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(DataBase dataBase, boolean isLog) throws Exception {
        String CONNECTION_URL = ImpalaJdbcUtil.getImpalaJdbcUrl(dataBase.getEnv(), dataBase.getType(), dataBase.getDatabase(), dataBase.getLable());
        DruidDataSource druidDataSource = dataSourceMap.get(CONNECTION_URL);
        if (isLog) {
            logger.info("\u5f53\u524d\u8fde\u63a5\u6c60\u4fe1\u606f\uff1a" + druidDataSource);
        }
        if (null != druidDataSource && !druidDataSource.isClosed()) {
            return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
        }
        Object object = LOCK;
        synchronized (object) {
            druidDataSource = dataSourceMap.get(CONNECTION_URL);
            if (null != druidDataSource && !druidDataSource.isClosed()) {
                return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
            }
            druidDataSource = DruidConnectionPoolUtil.druidConnectionPoolInit(CONNECTION_URL, dataBase);
            dataSourceMap.put(CONNECTION_URL, druidDataSource);
            return DruidConnectionPoolUtil.getJdbcConn(CONNECTION_URL, dataBase, druidDataSource);
        }
    }

    public static DruidDataSource druidConnectionPoolInit(String url, DataBase dataBase) throws Exception {
        Properties prop = new Properties();
        prop.setProperty("driverClassName", ImpalaUtilConstants.JDBC_DRIVER_MAP.get(dataBase.getType()));
        prop.setProperty("url", url);
        prop.setProperty("username", dataBase.getUserName());
        prop.setProperty("password", dataBase.getPasswd());
        prop.setProperty("initialSize", dataBase.getInitialSize());
        prop.setProperty("maxActive", dataBase.getMaxActive());
        prop.setProperty("minIdle", dataBase.getMinIdle());
        prop.setProperty("maxWait", dataBase.getMaxWait());
        prop.setProperty("filters", dataBase.getFilters());
        prop.setProperty("timeBetweenEvictionRunsMillis", dataBase.getTimeBetweenEvictionRunsMillis());
        prop.setProperty("minEvictableIdleTimeMillis", dataBase.getMinEvictableIdleTimeMillis());
        prop.setProperty("testWhileIdle", dataBase.getTestWhileIdle());
        prop.setProperty("testOnBorrow", dataBase.getTestOnBorrow());
        prop.setProperty("testOnReturn", dataBase.getTestOnReturn());
        prop.setProperty("poolPreparedStatements", dataBase.getPoolPreparedStatements());
        prop.setProperty("maxPoolPreparedStatementPerConnectionSize", dataBase.getMaxPoolPreparedStatementPerConnectionSize());
        prop.setProperty("validationQuery", dataBase.getValidationQuery());
        prop.setProperty("removeAbandoned", dataBase.getRemoveAbandoned());
        prop.setProperty("removeAbandonedTimeout", dataBase.getRemoveAbandonedTimeout());
        prop.setProperty("logAbandoned", dataBase.getLogAbandoned());
        return (DruidDataSource)DruidDataSourceFactory.createDataSource(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getJdbcConn(String connUrl, DataBase dataBase, DruidDataSource druidDataSource) throws Exception {
        if ("test_dev".equals(dataBase.getEnv()) || "test_hw".equals(dataBase.getEnv()) || "prod_azure".equals(dataBase.getEnv()) || "prod_hw".equals(dataBase.getEnv())) {
            DruidPooledConnection connection;
            try {
                connection = druidDataSource.getConnection();
            }
            catch (SQLException e) {
                logger.warn("================>   impala url: " + connUrl + " \u8fde\u63a5\u4e0d\u4e0a\uff0c\u5c1d\u8bd5\u8fde\u63a5impala HA");
                dataSourceMap.remove(connUrl);
                if (null != druidHADataSource && !druidHADataSource.isClosed()) {
                    connection = druidHADataSource.getConnection();
                }
                String CONNECTION_HA_URL = ImpalaJdbcUtil.getImpalaHAJdbcUrl(dataBase.getEnv(), dataBase.getType(), dataBase.getDatabase());
                Object object = HA_LOCK;
                synchronized (object) {
                    druidHADataSource = DruidConnectionPoolUtil.druidConnectionPoolInit(CONNECTION_HA_URL, dataBase);
                    connection = druidHADataSource.getConnection();
                }
            }
            return connection;
        }
        throw new RuntimeException("getJdbcConn\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6eenv\u914d\u7f6e");
    }

    public static void close() {
        for (String keyUrl : dataSourceMap.keySet()) {
            DruidDataSource druidDataSource = dataSourceMap.get(keyUrl);
            if (druidDataSource.isClosed()) continue;
            druidDataSource.close();
        }
        if (null != druidHADataSource && !druidHADataSource.isClosed()) {
            druidHADataSource.close();
        }
    }

    static {
        dataSourceMap = new ConcurrentHashMap<String, DruidDataSource>();
        LOCK = new Object();
        HA_LOCK = new Object();
    }
}

